﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Keyboard.h"


namespace ApConnectivityTest {
namespace UI {

Keyboard::FullKeyKeyMap Keyboard::KeyMap_FullKey;

const Keyboard::Key Keyboard::FullKeyKeyMap::m_KeysJp[] =
{
    { '1'   , '!'   , nullptr, nullptr,{ { { 0.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[13],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[1], &Keyboard::FullKeyKeyMap::m_KeysJp[14] },
    { '2'   , '"'   , nullptr, nullptr,{ { { 1.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[0],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[2], &Keyboard::FullKeyKeyMap::m_KeysJp[15] },
    { '3'   , '#'   , nullptr, nullptr,{ { { 2.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[1],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[3], &Keyboard::FullKeyKeyMap::m_KeysJp[16] },
    { '4'   , '$'   , nullptr, nullptr,{ { { 3.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[2],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[4], &Keyboard::FullKeyKeyMap::m_KeysJp[17] },
    { '5'   , '%'   , nullptr, nullptr,{ { { 4.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[3],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[5], &Keyboard::FullKeyKeyMap::m_KeysJp[18] },
    { '6'   , '&'   , nullptr, nullptr,{ { { 5.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[4],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[6], &Keyboard::FullKeyKeyMap::m_KeysJp[19] },
    { '7'   , '\''  , nullptr, nullptr,{ { { 6.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[5],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[7], &Keyboard::FullKeyKeyMap::m_KeysJp[20] },
    { '8'   , '('   , nullptr, nullptr,{ { { 7.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[6],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[8], &Keyboard::FullKeyKeyMap::m_KeysJp[21] },
    { '9'   , ')'   , nullptr, nullptr,{ { { 8.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[7],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[9], &Keyboard::FullKeyKeyMap::m_KeysJp[22] },
    { '0'   , '\0'  , nullptr, nullptr,{ { { 9.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[8],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[10], &Keyboard::FullKeyKeyMap::m_KeysJp[23] },
    { '-'   , '='   , nullptr, nullptr,{ { { 10.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[9],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[11], &Keyboard::FullKeyKeyMap::m_KeysJp[24] },
    { '^'   , '~'   , nullptr, nullptr,{ { { 11.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[10],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[12], &Keyboard::FullKeyKeyMap::m_KeysJp[25] },
    { '\\'  , '|'   , nullptr, nullptr,{ { { 12.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[11],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[13], &Keyboard::FullKeyKeyMap::m_KeysJp[25] },
    { '\x81', '\x81', "BkSp" , "BkSp" ,{ { { 13.5f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[12],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysJp[0], &Keyboard::FullKeyKeyMap::m_KeysJp[26] },

    { 'q'   , 'Q'   , nullptr, nullptr,{ { { 1.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[26], &Keyboard::FullKeyKeyMap::m_KeysJp[0], &Keyboard::FullKeyKeyMap::m_KeysJp[15], &Keyboard::FullKeyKeyMap::m_KeysJp[27] },
    { 'w'   , 'W'   , nullptr, nullptr,{ { { 2.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[14], &Keyboard::FullKeyKeyMap::m_KeysJp[1], &Keyboard::FullKeyKeyMap::m_KeysJp[16], &Keyboard::FullKeyKeyMap::m_KeysJp[28] },
    { 'e'   , 'E'   , nullptr, nullptr,{ { { 3.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[15], &Keyboard::FullKeyKeyMap::m_KeysJp[2], &Keyboard::FullKeyKeyMap::m_KeysJp[17], &Keyboard::FullKeyKeyMap::m_KeysJp[29] },
    { 'r'   , 'R'   , nullptr, nullptr,{ { { 4.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[16], &Keyboard::FullKeyKeyMap::m_KeysJp[3], &Keyboard::FullKeyKeyMap::m_KeysJp[18], &Keyboard::FullKeyKeyMap::m_KeysJp[30] },
    { 't'   , 'T'   , nullptr, nullptr,{ { { 5.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[17], &Keyboard::FullKeyKeyMap::m_KeysJp[4], &Keyboard::FullKeyKeyMap::m_KeysJp[19], &Keyboard::FullKeyKeyMap::m_KeysJp[31] },
    { 'y'   , 'Y'   , nullptr, nullptr,{ { { 6.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[18], &Keyboard::FullKeyKeyMap::m_KeysJp[5], &Keyboard::FullKeyKeyMap::m_KeysJp[20], &Keyboard::FullKeyKeyMap::m_KeysJp[32] },
    { 'u'   , 'U'   , nullptr, nullptr,{ { { 7.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[19], &Keyboard::FullKeyKeyMap::m_KeysJp[6], &Keyboard::FullKeyKeyMap::m_KeysJp[21], &Keyboard::FullKeyKeyMap::m_KeysJp[33] },
    { 'i'   , 'I'   , nullptr, nullptr,{ { { 8.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[20], &Keyboard::FullKeyKeyMap::m_KeysJp[7], &Keyboard::FullKeyKeyMap::m_KeysJp[22], &Keyboard::FullKeyKeyMap::m_KeysJp[34] },
    { 'o'   , 'O'   , nullptr, nullptr,{ { { 9.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[21], &Keyboard::FullKeyKeyMap::m_KeysJp[8], &Keyboard::FullKeyKeyMap::m_KeysJp[23], &Keyboard::FullKeyKeyMap::m_KeysJp[35] },
    { 'p'   , 'P'   , nullptr, nullptr,{ { { 10.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[22], &Keyboard::FullKeyKeyMap::m_KeysJp[9], &Keyboard::FullKeyKeyMap::m_KeysJp[24], &Keyboard::FullKeyKeyMap::m_KeysJp[36] },
    { '@'   , '`'   , nullptr, nullptr,{ { { 11.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[23], &Keyboard::FullKeyKeyMap::m_KeysJp[10], &Keyboard::FullKeyKeyMap::m_KeysJp[25], &Keyboard::FullKeyKeyMap::m_KeysJp[37] },
    { '['   , '{'   , nullptr, nullptr,{ { { 12.0f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[24], &Keyboard::FullKeyKeyMap::m_KeysJp[11], &Keyboard::FullKeyKeyMap::m_KeysJp[26], &Keyboard::FullKeyKeyMap::m_KeysJp[38] },
    { '\x80', '\x80', "Enter", "Enter",{ { { 13.25f , 1.5f } } },{ { { 1.5f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[25], &Keyboard::FullKeyKeyMap::m_KeysJp[13], &Keyboard::FullKeyKeyMap::m_KeysJp[14], &Keyboard::FullKeyKeyMap::m_KeysJp[39] },

    { 'a'   , 'A'   , nullptr, nullptr,{ { { 1.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[39], &Keyboard::FullKeyKeyMap::m_KeysJp[14], &Keyboard::FullKeyKeyMap::m_KeysJp[28], &Keyboard::FullKeyKeyMap::m_KeysJp[41] },
    { 's'   , 'S'   , nullptr, nullptr,{ { { 2.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[27], &Keyboard::FullKeyKeyMap::m_KeysJp[15], &Keyboard::FullKeyKeyMap::m_KeysJp[29], &Keyboard::FullKeyKeyMap::m_KeysJp[42] },
    { 'd'   , 'D'   , nullptr, nullptr,{ { { 3.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[28], &Keyboard::FullKeyKeyMap::m_KeysJp[16], &Keyboard::FullKeyKeyMap::m_KeysJp[30], &Keyboard::FullKeyKeyMap::m_KeysJp[43] },
    { 'f'   , 'F'   , nullptr, nullptr,{ { { 4.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[29], &Keyboard::FullKeyKeyMap::m_KeysJp[17], &Keyboard::FullKeyKeyMap::m_KeysJp[31], &Keyboard::FullKeyKeyMap::m_KeysJp[44] },
    { 'g'   , 'G'   , nullptr, nullptr,{ { { 5.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[30], &Keyboard::FullKeyKeyMap::m_KeysJp[18], &Keyboard::FullKeyKeyMap::m_KeysJp[32], &Keyboard::FullKeyKeyMap::m_KeysJp[45] },
    { 'h'   , 'H'   , nullptr, nullptr,{ { { 6.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[31], &Keyboard::FullKeyKeyMap::m_KeysJp[19], &Keyboard::FullKeyKeyMap::m_KeysJp[33], &Keyboard::FullKeyKeyMap::m_KeysJp[46] },
    { 'j'   , 'J'   , nullptr, nullptr,{ { { 7.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[32], &Keyboard::FullKeyKeyMap::m_KeysJp[20], &Keyboard::FullKeyKeyMap::m_KeysJp[34], &Keyboard::FullKeyKeyMap::m_KeysJp[47] },
    { 'k'   , 'K'   , nullptr, nullptr,{ { { 8.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[33], &Keyboard::FullKeyKeyMap::m_KeysJp[21], &Keyboard::FullKeyKeyMap::m_KeysJp[35], &Keyboard::FullKeyKeyMap::m_KeysJp[48] },
    { 'l'   , 'L'   , nullptr, nullptr,{ { { 9.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[34], &Keyboard::FullKeyKeyMap::m_KeysJp[22], &Keyboard::FullKeyKeyMap::m_KeysJp[36], &Keyboard::FullKeyKeyMap::m_KeysJp[49] },
    { ';'   , '+'   , nullptr, nullptr,{ { { 10.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[35], &Keyboard::FullKeyKeyMap::m_KeysJp[23], &Keyboard::FullKeyKeyMap::m_KeysJp[37], &Keyboard::FullKeyKeyMap::m_KeysJp[50] },
    { ':'   , '*'   , nullptr, nullptr,{ { { 11.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[36], &Keyboard::FullKeyKeyMap::m_KeysJp[24], &Keyboard::FullKeyKeyMap::m_KeysJp[38], &Keyboard::FullKeyKeyMap::m_KeysJp[51] },
    { ']'   , '}'   , nullptr, nullptr,{ { { 12.25f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[37], &Keyboard::FullKeyKeyMap::m_KeysJp[25], &Keyboard::FullKeyKeyMap::m_KeysJp[39], &Keyboard::FullKeyKeyMap::m_KeysJp[51] },
    { ' '   , ' '   , "Space", "Space",{ { { 13.375f, 2.5f } } },{ { { 1.25f, 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[38], &Keyboard::FullKeyKeyMap::m_KeysJp[26], &Keyboard::FullKeyKeyMap::m_KeysJp[27], &Keyboard::FullKeyKeyMap::m_KeysJp[52] },

    { '\x83', '\x83', "US/JP", "US/JP",{ { { 0.625f, 3.5f } } },{ { { 1.25f, 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[52], &Keyboard::FullKeyKeyMap::m_KeysJp[27], &Keyboard::FullKeyKeyMap::m_KeysJp[41],                                nullptr },
    { 'z'   , 'Z'   , nullptr, nullptr,{ { { 1.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[40], &Keyboard::FullKeyKeyMap::m_KeysJp[27], &Keyboard::FullKeyKeyMap::m_KeysJp[42],                                nullptr },
    { 'x'   , 'X'   , nullptr, nullptr,{ { { 2.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[41], &Keyboard::FullKeyKeyMap::m_KeysJp[28], &Keyboard::FullKeyKeyMap::m_KeysJp[43],                                nullptr },
    { 'c'   , 'C'   , nullptr, nullptr,{ { { 3.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[42], &Keyboard::FullKeyKeyMap::m_KeysJp[29], &Keyboard::FullKeyKeyMap::m_KeysJp[44],                                nullptr },
    { 'v'   , 'V'   , nullptr, nullptr,{ { { 4.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[43], &Keyboard::FullKeyKeyMap::m_KeysJp[30], &Keyboard::FullKeyKeyMap::m_KeysJp[45],                                nullptr },
    { 'b'   , 'B'   , nullptr, nullptr,{ { { 5.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[44], &Keyboard::FullKeyKeyMap::m_KeysJp[31], &Keyboard::FullKeyKeyMap::m_KeysJp[46],                                nullptr },
    { 'n'   , 'N'   , nullptr, nullptr,{ { { 6.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[45], &Keyboard::FullKeyKeyMap::m_KeysJp[32], &Keyboard::FullKeyKeyMap::m_KeysJp[47],                                nullptr },
    { 'm'   , 'M'   , nullptr, nullptr,{ { { 7.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[46], &Keyboard::FullKeyKeyMap::m_KeysJp[33], &Keyboard::FullKeyKeyMap::m_KeysJp[48],                                nullptr },
    { ','   , '<'   , nullptr, nullptr,{ { { 8.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[47], &Keyboard::FullKeyKeyMap::m_KeysJp[34], &Keyboard::FullKeyKeyMap::m_KeysJp[49],                                nullptr },
    { '.'   , '>'   , nullptr, nullptr,{ { { 9.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[48], &Keyboard::FullKeyKeyMap::m_KeysJp[35], &Keyboard::FullKeyKeyMap::m_KeysJp[50],                                nullptr },
    { '/'   , '?'   , nullptr, nullptr,{ { { 10.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[49], &Keyboard::FullKeyKeyMap::m_KeysJp[36], &Keyboard::FullKeyKeyMap::m_KeysJp[51],                                nullptr },
    { '\\'  , '_'   , nullptr, nullptr,{ { { 11.75f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[50], &Keyboard::FullKeyKeyMap::m_KeysJp[37], &Keyboard::FullKeyKeyMap::m_KeysJp[52],                                nullptr },
    { '\x82', '\x82', "Shift", "Shift",{ { { 13.125f, 3.5f } } }, { { { 1.75f, 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysJp[51], &Keyboard::FullKeyKeyMap::m_KeysJp[39], &Keyboard::FullKeyKeyMap::m_KeysJp[40],                                nullptr },

    { },
};


Keyboard::NumberKeyMap Keyboard::KeyMap_Number;

const Keyboard::Key Keyboard::FullKeyKeyMap::m_KeysUs[] =
{
    { '`'   , '~'   , nullptr, nullptr,{ { { 0.25f , 0.5f } } },{ { { 0.5f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[13],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[1], &Keyboard::FullKeyKeyMap::m_KeysUs[27] },
    { '1'   , '!'   , nullptr, nullptr,{ { { 1.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[0],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[2], &Keyboard::FullKeyKeyMap::m_KeysUs[14] },
    { '2'   , '@'   , nullptr, nullptr,{ { { 2.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[1],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[3], &Keyboard::FullKeyKeyMap::m_KeysUs[15] },
    { '3'   , '#'   , nullptr, nullptr,{ { { 3.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[2],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[4], &Keyboard::FullKeyKeyMap::m_KeysUs[16] },
    { '4'   , '$'   , nullptr, nullptr,{ { { 4.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[3],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[5], &Keyboard::FullKeyKeyMap::m_KeysUs[17] },
    { '5'   , '%'   , nullptr, nullptr,{ { { 5.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[4],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[6], &Keyboard::FullKeyKeyMap::m_KeysUs[18] },
    { '6'   , '^'   , nullptr, nullptr,{ { { 6.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[5],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[7], &Keyboard::FullKeyKeyMap::m_KeysUs[19] },
    { '7'   , '&'   , nullptr, nullptr,{ { { 7.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[6],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[8], &Keyboard::FullKeyKeyMap::m_KeysUs[20] },
    { '8'   , '*'   , nullptr, nullptr,{ { { 8.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[7],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[9], &Keyboard::FullKeyKeyMap::m_KeysUs[21] },
    { '9'   , '('   , nullptr, nullptr,{ { { 9.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[8],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[10], &Keyboard::FullKeyKeyMap::m_KeysUs[22] },
    { '0'   , ')'   , nullptr, nullptr,{ { { 10.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[9],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[11], &Keyboard::FullKeyKeyMap::m_KeysUs[23] },
    { '-'   , '_'   , nullptr, nullptr,{ { { 11.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[10],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[12], &Keyboard::FullKeyKeyMap::m_KeysUs[24] },
    { '='   , '+'   , nullptr, nullptr,{ { { 12.0f  , 0.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[11],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[13], &Keyboard::FullKeyKeyMap::m_KeysUs[25] },
    { '\x81', '\x81', "BkSp" , "BkSp" ,{ { { 13.25f , 0.5f } } },{ { { 1.5f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[12],                                nullptr, &Keyboard::FullKeyKeyMap::m_KeysUs[0], &Keyboard::FullKeyKeyMap::m_KeysUs[26] },

    { 'q'   , 'Q'   , nullptr, nullptr,{ { { 1.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[26], &Keyboard::FullKeyKeyMap::m_KeysUs[1], &Keyboard::FullKeyKeyMap::m_KeysUs[15], &Keyboard::FullKeyKeyMap::m_KeysUs[28] },
    { 'w'   , 'W'   , nullptr, nullptr,{ { { 2.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[14], &Keyboard::FullKeyKeyMap::m_KeysUs[2], &Keyboard::FullKeyKeyMap::m_KeysUs[16], &Keyboard::FullKeyKeyMap::m_KeysUs[29] },
    { 'e'   , 'E'   , nullptr, nullptr,{ { { 3.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[15], &Keyboard::FullKeyKeyMap::m_KeysUs[3], &Keyboard::FullKeyKeyMap::m_KeysUs[17], &Keyboard::FullKeyKeyMap::m_KeysUs[30] },
    { 'r'   , 'R'   , nullptr, nullptr,{ { { 4.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[16], &Keyboard::FullKeyKeyMap::m_KeysUs[4], &Keyboard::FullKeyKeyMap::m_KeysUs[18], &Keyboard::FullKeyKeyMap::m_KeysUs[31] },
    { 't'   , 'T'   , nullptr, nullptr,{ { { 5.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[17], &Keyboard::FullKeyKeyMap::m_KeysUs[5], &Keyboard::FullKeyKeyMap::m_KeysUs[19], &Keyboard::FullKeyKeyMap::m_KeysUs[32] },
    { 'y'   , 'Y'   , nullptr, nullptr,{ { { 6.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[18], &Keyboard::FullKeyKeyMap::m_KeysUs[6], &Keyboard::FullKeyKeyMap::m_KeysUs[20], &Keyboard::FullKeyKeyMap::m_KeysUs[33] },
    { 'u'   , 'U'   , nullptr, nullptr,{ { { 7.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[19], &Keyboard::FullKeyKeyMap::m_KeysUs[7], &Keyboard::FullKeyKeyMap::m_KeysUs[21], &Keyboard::FullKeyKeyMap::m_KeysUs[34] },
    { 'i'   , 'I'   , nullptr, nullptr,{ { { 8.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[20], &Keyboard::FullKeyKeyMap::m_KeysUs[8], &Keyboard::FullKeyKeyMap::m_KeysUs[22], &Keyboard::FullKeyKeyMap::m_KeysUs[35] },
    { 'o'   , 'O'   , nullptr, nullptr,{ { { 9.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[21], &Keyboard::FullKeyKeyMap::m_KeysUs[9], &Keyboard::FullKeyKeyMap::m_KeysUs[23], &Keyboard::FullKeyKeyMap::m_KeysUs[36] },
    { 'p'   , 'P'   , nullptr, nullptr,{ { { 10.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[22], &Keyboard::FullKeyKeyMap::m_KeysUs[10], &Keyboard::FullKeyKeyMap::m_KeysUs[24], &Keyboard::FullKeyKeyMap::m_KeysUs[37] },
    { '['   , '{'   , nullptr, nullptr,{ { { 11.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[23], &Keyboard::FullKeyKeyMap::m_KeysUs[11], &Keyboard::FullKeyKeyMap::m_KeysUs[25], &Keyboard::FullKeyKeyMap::m_KeysUs[38] },
    { ']'   , '}'   , nullptr, nullptr,{ { { 12.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[24], &Keyboard::FullKeyKeyMap::m_KeysUs[12], &Keyboard::FullKeyKeyMap::m_KeysUs[26], &Keyboard::FullKeyKeyMap::m_KeysUs[39] },
    { '\\'  , '|'   , nullptr, nullptr,{ { { 13.5f  , 1.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[25], &Keyboard::FullKeyKeyMap::m_KeysUs[13], &Keyboard::FullKeyKeyMap::m_KeysUs[14], &Keyboard::FullKeyKeyMap::m_KeysUs[39] },

    { ' '   , ' '   , "Space", "Space",{ { { 0.625f, 2.5f } } },{ { { 1.25f, 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[39], &Keyboard::FullKeyKeyMap::m_KeysUs[0], &Keyboard::FullKeyKeyMap::m_KeysUs[28], &Keyboard::FullKeyKeyMap::m_KeysUs[40] },
    { 'a'   , 'A'   , nullptr, nullptr,{ { { 1.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[27], &Keyboard::FullKeyKeyMap::m_KeysUs[14], &Keyboard::FullKeyKeyMap::m_KeysUs[29], &Keyboard::FullKeyKeyMap::m_KeysUs[41] },
    { 's'   , 'S'   , nullptr, nullptr,{ { { 2.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[28], &Keyboard::FullKeyKeyMap::m_KeysUs[15], &Keyboard::FullKeyKeyMap::m_KeysUs[30], &Keyboard::FullKeyKeyMap::m_KeysUs[42] },
    { 'd'   , 'D'   , nullptr, nullptr,{ { { 3.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[29], &Keyboard::FullKeyKeyMap::m_KeysUs[16], &Keyboard::FullKeyKeyMap::m_KeysUs[31], &Keyboard::FullKeyKeyMap::m_KeysUs[43] },
    { 'f'   , 'F'   , nullptr, nullptr,{ { { 4.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[30], &Keyboard::FullKeyKeyMap::m_KeysUs[17], &Keyboard::FullKeyKeyMap::m_KeysUs[32], &Keyboard::FullKeyKeyMap::m_KeysUs[44] },
    { 'g'   , 'G'   , nullptr, nullptr,{ { { 5.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[31], &Keyboard::FullKeyKeyMap::m_KeysUs[18], &Keyboard::FullKeyKeyMap::m_KeysUs[33], &Keyboard::FullKeyKeyMap::m_KeysUs[45] },
    { 'h'   , 'H'   , nullptr, nullptr,{ { { 6.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[32], &Keyboard::FullKeyKeyMap::m_KeysUs[19], &Keyboard::FullKeyKeyMap::m_KeysUs[34], &Keyboard::FullKeyKeyMap::m_KeysUs[46] },
    { 'j'   , 'J'   , nullptr, nullptr,{ { { 7.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[33], &Keyboard::FullKeyKeyMap::m_KeysUs[20], &Keyboard::FullKeyKeyMap::m_KeysUs[35], &Keyboard::FullKeyKeyMap::m_KeysUs[47] },
    { 'k'   , 'K'   , nullptr, nullptr,{ { { 8.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[34], &Keyboard::FullKeyKeyMap::m_KeysUs[21], &Keyboard::FullKeyKeyMap::m_KeysUs[36], &Keyboard::FullKeyKeyMap::m_KeysUs[48] },
    { 'l'   , 'L'   , nullptr, nullptr,{ { { 9.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[35], &Keyboard::FullKeyKeyMap::m_KeysUs[22], &Keyboard::FullKeyKeyMap::m_KeysUs[37], &Keyboard::FullKeyKeyMap::m_KeysUs[49] },
    { ';'   , ':'   , nullptr, nullptr,{ { { 10.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[36], &Keyboard::FullKeyKeyMap::m_KeysUs[23], &Keyboard::FullKeyKeyMap::m_KeysUs[38], &Keyboard::FullKeyKeyMap::m_KeysUs[50] },
    { '\''  , '"'   , nullptr, nullptr,{ { { 11.75f , 2.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[37], &Keyboard::FullKeyKeyMap::m_KeysUs[24], &Keyboard::FullKeyKeyMap::m_KeysUs[39], &Keyboard::FullKeyKeyMap::m_KeysUs[50] },
    { '\x80', '\x80', "Enter", "Enter",{ { { 13.125f, 2.5f } } },{ { { 1.75f, 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[38], &Keyboard::FullKeyKeyMap::m_KeysUs[26], &Keyboard::FullKeyKeyMap::m_KeysUs[27], &Keyboard::FullKeyKeyMap::m_KeysUs[51] },

    { '\x83', '\x83', "US/JP", "US/JP",{ { { 0.875f, 3.5f } } },{ { { 1.75f, 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[51], &Keyboard::FullKeyKeyMap::m_KeysUs[27], &Keyboard::FullKeyKeyMap::m_KeysUs[41],                                nullptr },
    { 'z'   , 'Z'   , nullptr, nullptr,{ { { 2.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[40], &Keyboard::FullKeyKeyMap::m_KeysUs[28], &Keyboard::FullKeyKeyMap::m_KeysUs[42],                                nullptr },
    { 'x'   , 'X'   , nullptr, nullptr,{ { { 3.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[41], &Keyboard::FullKeyKeyMap::m_KeysUs[29], &Keyboard::FullKeyKeyMap::m_KeysUs[43],                                nullptr },
    { 'c'   , 'C'   , nullptr, nullptr,{ { { 4.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[42], &Keyboard::FullKeyKeyMap::m_KeysUs[30], &Keyboard::FullKeyKeyMap::m_KeysUs[44],                                nullptr },
    { 'v'   , 'V'   , nullptr, nullptr,{ { { 5.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[43], &Keyboard::FullKeyKeyMap::m_KeysUs[31], &Keyboard::FullKeyKeyMap::m_KeysUs[45],                                nullptr },
    { 'b'   , 'B'   , nullptr, nullptr,{ { { 6.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[44], &Keyboard::FullKeyKeyMap::m_KeysUs[32], &Keyboard::FullKeyKeyMap::m_KeysUs[46],                                nullptr },
    { 'n'   , 'N'   , nullptr, nullptr,{ { { 7.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[45], &Keyboard::FullKeyKeyMap::m_KeysUs[33], &Keyboard::FullKeyKeyMap::m_KeysUs[47],                                nullptr },
    { 'm'   , 'M'   , nullptr, nullptr,{ { { 8.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[46], &Keyboard::FullKeyKeyMap::m_KeysUs[34], &Keyboard::FullKeyKeyMap::m_KeysUs[48],                                nullptr },
    { ','   , '<'   , nullptr, nullptr,{ { { 9.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[47], &Keyboard::FullKeyKeyMap::m_KeysUs[35], &Keyboard::FullKeyKeyMap::m_KeysUs[49],                                nullptr },
    { '.'   , '>'   , nullptr, nullptr,{ { { 10.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[48], &Keyboard::FullKeyKeyMap::m_KeysUs[36], &Keyboard::FullKeyKeyMap::m_KeysUs[50],                                nullptr },
    { '/'   , '?'   , nullptr, nullptr,{ { { 11.25f , 3.5f } } },{ { { 1.0f , 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[49], &Keyboard::FullKeyKeyMap::m_KeysUs[37], &Keyboard::FullKeyKeyMap::m_KeysUs[51],                                nullptr },
    { '\x82', '\x82', "Shift", "Shift",{ { { 12.875f, 3.5f } } }, { { { 2.25f, 1.0f } } }, &Keyboard::FullKeyKeyMap::m_KeysUs[50], &Keyboard::FullKeyKeyMap::m_KeysUs[39], &Keyboard::FullKeyKeyMap::m_KeysUs[40],                                nullptr },

    {},
};


Keyboard::FullKeyKeyMap::FullKeyKeyMap() :
        m_ActiveKeyMap(KeyMapType_Jp)
{
}


Keyboard::FullKeyKeyMap::~FullKeyKeyMap()
{
}


const Keyboard::Key* Keyboard::FullKeyKeyMap::GetKeys() const
{
    switch (m_ActiveKeyMap)
    {
    case KeyMapType_Jp:
        return m_KeysJp;

    case KeyMapType_Us:
        return m_KeysUs;

    default:
        break;
    }
}


void Keyboard::FullKeyKeyMap::SpecialKeyDown(Keyboard& keyboard, char key)
{
    switch (key)
    {
    case '\x80':
        keyboard.Enter();
        break;

    case '\x81':
        keyboard.BackSpace();
        break;

    case '\x82':
        keyboard.ToggleShift();
        break;

    case '\x83':
        switch (m_ActiveKeyMap)
        {
        case KeyMapType_Jp:
            m_ActiveKeyMap = KeyMapType_Us;
            keyboard.m_ActiveKey = &m_KeysUs[40];
            break;

        case KeyMapType_Us:
            m_ActiveKeyMap = KeyMapType_Jp;
            keyboard.m_ActiveKey = &m_KeysJp[40];
            break;

        default:
            break;
        }
        break;

    default:
        break;
    }
}


void Keyboard::FullKeyKeyMap::SpecialKeyDown(Keyboard& keyboard)
{
    keyboard.Input(' ');
}


const Keyboard::Key Keyboard::NumberKeyMap::m_Keys[] =
{
    { '7'   , '~'   , nullptr, nullptr, { { { 6.00f , 0.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 2],                             nullptr, &Keyboard::NumberKeyMap::m_Keys[ 1], &Keyboard::NumberKeyMap::m_Keys[ 3] },
    { '8'   , '~'   , nullptr, nullptr, { { { 7.00f , 0.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 0],                             nullptr, &Keyboard::NumberKeyMap::m_Keys[ 2], &Keyboard::NumberKeyMap::m_Keys[ 4] },
    { '9'   , '~'   , nullptr, nullptr, { { { 8.00f , 0.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 1],                             nullptr, &Keyboard::NumberKeyMap::m_Keys[ 0], &Keyboard::NumberKeyMap::m_Keys[ 5] },

    { '4'   , '~'   , nullptr, nullptr, { { { 6.00f , 1.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 5], &Keyboard::NumberKeyMap::m_Keys[ 0], &Keyboard::NumberKeyMap::m_Keys[ 4], &Keyboard::NumberKeyMap::m_Keys[ 6] },
    { '5'   , '~'   , nullptr, nullptr, { { { 7.00f , 1.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 3], &Keyboard::NumberKeyMap::m_Keys[ 1], &Keyboard::NumberKeyMap::m_Keys[ 5], &Keyboard::NumberKeyMap::m_Keys[ 7] },
    { '6'   , '~'   , nullptr, nullptr, { { { 8.00f , 1.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 4], &Keyboard::NumberKeyMap::m_Keys[ 2], &Keyboard::NumberKeyMap::m_Keys[ 3], &Keyboard::NumberKeyMap::m_Keys[ 8] },

    { '1'   , '~'   , nullptr, nullptr, { { { 6.00f , 2.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 8], &Keyboard::NumberKeyMap::m_Keys[ 3], &Keyboard::NumberKeyMap::m_Keys[ 7], &Keyboard::NumberKeyMap::m_Keys[ 9] },
    { '2'   , '~'   , nullptr, nullptr, { { { 7.00f , 2.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 6], &Keyboard::NumberKeyMap::m_Keys[ 4], &Keyboard::NumberKeyMap::m_Keys[ 8], &Keyboard::NumberKeyMap::m_Keys[10] },
    { '3'   , '~'   , nullptr, nullptr, { { { 8.00f , 2.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 7], &Keyboard::NumberKeyMap::m_Keys[ 5], &Keyboard::NumberKeyMap::m_Keys[ 6], &Keyboard::NumberKeyMap::m_Keys[11] },

    { '0'   , '~'   , nullptr, nullptr, { { { 6.00f , 3.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[11], &Keyboard::NumberKeyMap::m_Keys[ 6], &Keyboard::NumberKeyMap::m_Keys[10],                             nullptr },
    { '\x81', '\x81', "BkSp" , "BkSp" , { { { 7.00f , 3.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[ 9], &Keyboard::NumberKeyMap::m_Keys[ 7], &Keyboard::NumberKeyMap::m_Keys[11],                             nullptr },
    { '\x80', '\x80', "Enter", "Enter", { { { 8.00f , 3.5f } } }, { { { 1.0f, 1.0f } } }, &Keyboard::NumberKeyMap::m_Keys[10], &Keyboard::NumberKeyMap::m_Keys[ 8], &Keyboard::NumberKeyMap::m_Keys[ 9],                             nullptr },

    {}
};


Keyboard::NumberKeyMap::~NumberKeyMap()
{
}


const Keyboard::Key* Keyboard::NumberKeyMap::GetKeys() const
{
    return m_Keys;
}


void Keyboard::NumberKeyMap::SpecialKeyDown(Keyboard& keyboard, char key)
{
    switch (key)
    {
    case '\x80':
        keyboard.Enter();
        break;

    case '\x81':
        keyboard.BackSpace();
        break;

    default:
        break;
    }
}


void Keyboard::NumberKeyMap::SpecialKeyDown(Keyboard& keyboard)
{
}

}
}
