﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ConsoleView.h"
#include "Keyboard.h"
#include "Utils.h"
#include "gfxutil/GfxContext.h"
#include <nn/nn_Macro.h>
#include <nn/os/os_MutexTypes.h>
#include <functional>
#include <list>
#include <memory>
#include <string>
#include <vector>


namespace ApConnectivityTest {

class App;

namespace UI {

class Menu;
class ConsoleView;


class UI
{
    friend App;

public:
    void Initialize();
    void Finalize();

    void Update();

    void SetTopMenu(const std::shared_ptr<Menu>& menu);

    void PopupMenu(const std::shared_ptr<Menu>& menu);
    void CloseMenu();

    void OpenKeyboard(Keyboard::KeyMap& keyMap, const std::string& initialString, size_t minLength, size_t maxLength, const std::function<void(const std::string&)>& callback);
    void CloseKeyboard();

    gfxutil::GfxContext& GetGfxContext();

    ConsoleView& GetStatusConsole();

private:
    UI();
    virtual ~UI();

private:
    char* m_GfxContextMemoryPool;
    gfxutil::GfxContext m_GfxContext;

    int m_ScreenWidth;
    int m_ScreenHeight;

    std::list<std::shared_ptr<Menu>> m_MenuStack;

    ConsoleView m_StatusConsole;

    Keyboard m_Keyboard;
    bool m_ShowKeyboard;
};

}
}
