﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/vi/vi_DisplayMode.private.h>
#include "UnderscanMenu.h"
#include "UnderscanMenuItem.h"

UnderscanMenu::UnderscanMenu(nn::vi::Display* pDisplay)
    : m_pDisplay(pDisplay)
{
}

void UnderscanMenu::RefreshItems() NN_NOEXCEPT
{
    // Underscan range is from [0,20]
    for( int i = 0; i <= 20; ++i )
    {
        Add(std::make_unique<UnderscanMenuItem>(m_pDisplay, i));
    }
}

const char* UnderscanMenu::GetName() const NN_NOEXCEPT
{
    return "Underscan";
}

void UnderscanMenu::RenderCurrentSetting() const NN_NOEXCEPT
{
    int underscan;

    if( nn::vi::GetDisplayUnderscan(&underscan, m_pDisplay).IsSuccess() )
    {
        NN_LOG("%d", underscan);
    }
}
