﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/vi.private.h>
#include "ModeMenuItem.h"
#include "ModeMenu.h"
#include "Utility.h"

ModeMenu::ModeMenu(nn::vi::Display* pDisplay) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
{
}

void ModeMenu::RefreshItems() NN_NOEXCEPT
{
    // Using an array of this size will always allow all possible modes to be enumerated regardless
    // of the platform.
    nn::vi::DisplayModeInfo modes[nn::vi::DisplayModeCountMax];
    // The list returned will be filtered to only show the modes allowed on the current platform.
    int modeCount = nn::vi::ListDisplayModes(modes, sizeof(modes) / sizeof(modes[0]), m_pDisplay);

    for( int i = 0; i < modeCount; ++i )
    {
        Add(std::make_unique<ModeMenuItem>(m_pDisplay, modes[i]));
    }
}

const char* ModeMenu::GetName() const NN_NOEXCEPT
{
    return "Display Modes";
}

void ModeMenu::RenderCurrentSetting() const NN_NOEXCEPT
{
    nn::vi::DisplayModeInfo mode;

    if( nn::vi::GetDisplayMode(&mode, m_pDisplay).IsSuccess() )
    {
        PrintMode(mode);
    }
}
