﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/vi.private.h>
#include "GammaMenu.h"
#include "GammaMenuItem.h"
#include "Utility.h"

GammaMenu::GammaMenu(nn::vi::Display* pDisplay) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
{
}

void GammaMenu::RefreshItems() NN_NOEXCEPT
{
    nn::vi::CmuMode mode;
    if( nn::vi::GetDisplayCmuMode(&mode, m_pDisplay).IsSuccess() && mode == nn::vi::CmuMode_Default )
    {
        float values[] = { 1.f, 1.1f, 1.2f, 1.3f, 1.4f, 1.5f, 1.6f, 1.7f, 1.8f, 1.9f,
                           2.f, 2.1f, 2.2f, 2.3f, 2.4f, 2.5f, 2.6f, 2.7f, 2.8f, 2.9f,
                           3.f };

        for( int i = 0; i < sizeof(values) / sizeof(values[0]); ++i )
        {
            Add(std::make_unique<GammaMenuItem>(m_pDisplay, values[i]));
        }
    }
}

const char* GammaMenu::GetName() const NN_NOEXCEPT
{
    return "Gamma";
}

void GammaMenu::RenderCurrentSetting() const NN_NOEXCEPT
{
    nn::vi::CmuMode mode;

    if( nn::vi::GetDisplayCmuMode(&mode, m_pDisplay).IsSuccess() && mode == nn::vi::CmuMode_Default )
    {
        float gamma;

        if( nn::vi::GetDisplayGamma(&gamma, m_pDisplay).IsSuccess() )
        {
            NN_LOG("%f", gamma);
        }
    }
}
