﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Macro.h>
#include "IMenu.h"

class Controller;

class MenuManager
{
public:
    MenuManager() NN_NOEXCEPT;

    void Update(const Controller& input) NN_NOEXCEPT;
    void Render() const NN_NOEXCEPT;

    void Add(std::unique_ptr<IMenu>& menu) NN_NOEXCEPT;
private:
    typedef std::vector<std::unique_ptr<IMenu>> MenuList;
    MenuList m_Menus;

    MenuList::size_type m_MenuIndex;
};
