﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/vi/vi_CmuLuma.h>
#include "LumaMenuItem.h"

LumaMenuItem::LumaMenuItem(nn::vi::Display* pDisplay, float luma) NN_NOEXCEPT
    : m_pDisplay(pDisplay)
    , m_Luma(luma)
{
}

void LumaMenuItem::Render() const NN_NOEXCEPT
{
    NN_LOG("%f", m_Luma);
}

void LumaMenuItem::Select() NN_NOEXCEPT
{
    if( nn::vi::SetDisplayCmuLuma(m_pDisplay, m_Luma).IsFailure() )
    {
        NN_LOG("Failed to adjust luma value!\n");
    }
}
