﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

//---------------------------------------------
// フラグメントシェーダへ送る値
//---------------------------------------------
out vec4 gcShaderFragmentParam;        // LightRate


#ifdef SAMPLE_LIGHT
// パーティクルの法線を開く
const vec3 baseNormal = vec3( 0 , 0 , 1 );
const vec3 normalDir[4] = vec3[4]
(
    vec3( -1 , 1 ,0 ) ,
    vec3(  1 , 1 ,0 ) ,
    vec3( -1 ,-1 ,0 ) ,
    vec3(  1 ,-1 ,0 )
);


#define USE_USR_GET_LOCAL_NORMAL
vec3 GetLocalNormal()
{
#ifdef _PARTICLE
    vec3 norm = vec3(0);

    if ( v_inIndex == 0 ) norm = normalDir[ 0 ];
    if ( v_inIndex == 1 ) norm = normalDir[ 1 ];
    if ( v_inIndex == 2 ) norm = normalDir[ 2 ];
    if ( v_inIndex == 3 ) norm = normalDir[ 3 ];

    norm = baseNormal + norm * 0.5;
    normalize( norm );
    return norm;
#else
    return sysNormalAttr;
#endif
}


#endif


//--------------------------------------------------------------
// 位置調整
//--------------------------------------------------------------
#define USE_USR_ADJUSTMENT_WORLD_POSITION
void AdjustmentWorldPosition()
{
#ifdef CHANGE_POSITION
    // 指定した分だけ位置を加算
    gl_Position.x += u_PositionX;
    gl_Position.y += u_PositionY;
    gl_Position.z += u_PositionZ;
#endif
}

//---------------------------------------------------
// 最終出力調整
//---------------------------------------------------
#define USE_USR_FINAL_ADJUSTMENT_VERTEX_PROCSS
void FinalAdjustmentVertexProcess()
{
#ifdef SAMPLE_LIGHT
    // 頂点ライティングのサンプル。
    // ディレクショナルライト
    vec3 viewPosition   = vec3( sysViewMatrix * vec4( 0, 0, 0, 1 ) );
    vec3 viewLightPos   = vec3( sysViewMatrix * vec4( 0, 100, 100, 1 ) );
    vec3 viewLightVec   = normalize( viewLightPos - viewPosition );
    vec3 viewNormal     = normalize( ( sysViewMatrix * vec4( sysWorldNormalVary, 1 ) ).xyz );
    float diffuse = dot( viewLightVec, viewNormal );
    gcShaderFragmentParam.x = clamp( diffuse, 0.3, 1.0 );
#endif

    // 全てのシェーダでの共通処理
    CommonVertexProcess();
}
