﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/migration/migration_UserMigrationServer.h>

#include "UserMigration_SequenceBase.h"
#include "UserMigration_ScreenIo.h"

class ServerSequence final
    : public SequenceBase
{
public:
    enum class SceneKind
    {
        Start,
        End,

        CreateServer,
        Prepare,
        ProcessConnection,
        ProcessTransfer,
        Complete,
    };
    typedef SceneBase<SceneKind> SceneBase;

private:
    SceneKind m_CurrentScene;
    SceneKind m_NextScene;
    std::unique_ptr<SceneBase> m_Scene;

    nn::migration::UserMigrationServer m_Server;
    bool m_IsLockAcquired;

    void OnEntering(SceneKind next) NN_NOEXCEPT;

protected:
    virtual const Window::Components* GetCurrentSceneComponentsPtr() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void UpdateImpl() NN_NOEXCEPT NN_OVERRIDE;

public:
    explicit ServerSequence(Window& window) NN_NOEXCEPT;
    virtual ~ServerSequence() NN_NOEXCEPT NN_OVERRIDE;
};

