﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>

#define MIN_ALIGN nn::os::ThreadStackAlignment

static int TestResult = 0;
#define STACK_SIZE (3 * MIN_ALIGN)


static pthread_t        threadOne, threadTwo;

int                     GameMinus;
thread_local short      GamePlus;
thread_local char       GamePlus1 = 1;
thread_local int        GamePlus100 = 100;

static void GameUpdatePlusMinus()
{
    GameMinus -= 5;;
    GamePlus += 5;
    GamePlus1 += 5;
    GamePlus100 += 5;
}

/*---------------------------------------------------------------------------*
  Name:         TestThreadOne

  Description:  This is the main function of the thread.
                It displays the resulting values of each variable.

  Arguments:    not used.

  Returns:      Always zero

 *---------------------------------------------------------------------------*/


static void *TestThreadOne(void *arg)
{
    NN_UNUSED(arg);
    int i;

    for (i = 0; i < 5; i++)
    {
        NN_LOG("Hello! from TestThreadOne.\n");
        // normal global data
        GameMinus--;
        // thread local storage data
        GamePlus++;
        GamePlus100++;
        GameUpdatePlusMinus();
    }
    if ((GamePlus != 30) || (GamePlus100 != 130))
    {
        NN_LOG("ThreadOne: GameMinus=%d.\n",
            GameMinus);
        NN_LOG("ThreadOne: GamePlus=%d.\n",
            GamePlus);
        NN_LOG("ThreadOne: GamePlus100=%d.\n",
            GamePlus100);
        TestResult = -1;
    } else {
        NN_LOG("ThreadOne: Successful!\n");
    }
    return NULL;
}

/*---------------------------------------------------------------------------*
  Name:         TestThreadTwo

  Description:  This is the main function of the thread.
                It displays the resulting values of each variable.

  Arguments:    not used.

  Returns:      Always zero

 *---------------------------------------------------------------------------*/

static void *TestThreadTwo(void *arg)
{
    NN_UNUSED(arg);
    int i;

    for (i = 0; i < 5; i++)
    {
        NN_LOG("Hello! from TestThreadTwo.\n");
        // normal global data
        GameMinus--;
        // thread local storage data
        GamePlus++;
        GamePlus100++;
        GameUpdatePlusMinus();
    }
    if ((GamePlus != 30) || (GamePlus100 != 130))
    {
        NN_LOG("ThreadTwo: GameMinus=%d.\n",
            GameMinus);
        NN_LOG("ThreadTwo: GamePlus=%d.\n",
            GamePlus);
        NN_LOG("ThreadTwo: GamePlus100=%d.\n",
            GamePlus100);
        TestResult = -1;
    } else {
        NN_LOG("ThreadTwo: Successful!\n");
    }
    return NULL;
}

/*---------------------------------------------------------------------------*
  Name:         main

  Description:  This is the main function of the demo.

                This demo displays Hello! on the main thread and sub-threads.

  Arguments:    None.

  Returns:      Always zero.

 *---------------------------------------------------------------------------*/
extern "C" void nnMain()
{
    int                   rc=0;
    pthread_attr_t        ptaOne, ptaTwo;

    TestResult = 0;

    rc = pthread_attr_init(&ptaOne);
    if (rc) {
        NN_LOG ("pthread_attr_init() failed for ptaOne with error %d\n", rc);
        return;
    }
    rc = pthread_attr_setstacksize(&ptaOne, STACK_SIZE);
    if (rc) {
        NN_LOG ("pthread_attr_setstacksize() failed for ptaOne and STACK_SIZE %d with error %d\n", rc);
        return;
    }
    rc = pthread_create(&threadOne, &ptaOne, TestThreadOne, NULL);
    if (rc) {
        NN_LOG ("pthread_create() failed for threadOne with error %d\n", rc);
        return;
    }

    NN_LOG("threadOne = 0x%08zX\n", (size_t)threadOne);

    rc = pthread_attr_init(&ptaTwo);
    if (rc) {
        NN_LOG ("pthread_attr_init() failed for ptaTwo with error %d\n", rc);
        return;
    }
    rc = pthread_attr_setstacksize(&ptaTwo, STACK_SIZE);
    if (rc) {
        NN_LOG ("pthread_attr_setstacksize() failed for ptaTwo and STACK_SIZE %d with error %d\n", rc);
        return;
    }
    rc = pthread_create(&threadTwo, &ptaTwo, TestThreadTwo, NULL);
    if (rc) {
        NN_LOG ("pthread_create() failed for threadTwo with error %d\n", rc);
        return;
    }

    NN_LOG("threadTwo = 0x%08zX\n", (size_t)threadTwo);

    rc = pthread_join(threadOne, NULL);
    if (rc) {
        NN_LOG ("pthread_join() failed for threadOne with error %d\n", rc);
        return;
    }
    NN_LOG("threadOne did join\n");
    rc = pthread_join(threadTwo, NULL);
    if (rc) {
        NN_LOG ("pthread_join() failed for threadTwo with error %d\n", rc);
        return;
    }
    NN_LOG("threadTwo did join\n");

    rc = pthread_attr_destroy(&ptaOne);
    if (rc) {
        NN_LOG ("pthread_attr_destroy() failed for ptaOne with error %d\n", rc);
        return;
    }
    rc = pthread_attr_destroy(&ptaTwo);
    if (rc) {
        NN_LOG ("pthread_attr_destroy() failed for ptaTwo with error %d\n", rc);
        return;
    }

    if (TestResult == 0)
        NN_LOG("Test result: PASS\n");
    else
        NN_LOG("Test result: FAIL\n");
}

