﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Abort.h>
#include <nn/init/init_Malloc.h>
#include <nn/os.h>
#include <nn/os/os_MemoryAllocatorForThreadLocal.h>
#include <nn/os/os_SdkMemoryAllocatorForThreadLocal.h>
#include <nn/nn_Log.h>
#include <nn/init.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
namespace nn { namespace init { namespace detail {
    void* DefaultAllocatorForThreadLocal(size_t, size_t) NN_NOEXCEPT;
    void  DefaultDeallocatorForThreadLocal(void*, size_t) NN_NOEXCEPT;
}}} // namespace nn::init::detail
#endif  // NN_BUILD_CONFIG_OS_HORIZON

//---------------------------------------------------------------------------
//  デフォルトの nninitStartup() が適用されないように空関数として定義。
extern "C" void nninitStartup()
{
    static uint8_t TlsBuffer[128 * 1024 * 1024];
    nn::init::InitializeAllocator(TlsBuffer, sizeof(TlsBuffer));

    NN_LOG("Using default malloc allocators\n");

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    // コンパイラのスレッドローカル実装用のメモリアロケータの登録
    nn::os::SetMemoryAllocatorForThreadLocal(
                            nn::init::detail::DefaultAllocatorForThreadLocal,
                            nn::init::detail::DefaultDeallocatorForThreadLocal);

    NN_LOG("Using default TLS allocators\n");
#endif  // NN_BUILD_CONFIG_OS_HORIZON
}

