﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "MoviePlayer.h"
class MoviePlayerSimple
{
public:
    enum MoviePlayerSimpleEventType
    {
        MoviePlayerSimpleEventType_Unknown       = 0,
        MoviePlayerSimpleEventType_StateChanged  = 1,
        MoviePlayerSimpleEventType_Error         = 2,
        MoviePlayerSimpleEventType_ButtonPressA  = 3,
        MoviePlayerSimpleEventType_ButtonPressB  = 4,
        MoviePlayerSimpleEventType_ButtonPressX  = 5,
        MoviePlayerSimpleEventType_ButtonPressZr = 6,
        MoviePlayerSimpleEventType_ButtonPressL  = 7,
        MoviePlayerSimpleEventType_ButtonPressR  = 8,
    };

    MoviePlayerSimple();

    bool Initialize();

    void Finalize();

    bool CreateHidHandler();

    void DestroyHidHandler();

    movie::Status CreateMoviePlayer();

    void DestroyMoviePlayer();

    movie::Status PlayMovie(char* mediaFile, movie::DecoderMode videoDecoderMode);

    movie::Status SeekMovie(bool forward);

    bool HandleEvents();

    void RegisterEvent(nn::os::EventType *event, MoviePlayerSimpleEventType eventType);

    bool MountFileSystem(char* mediaFile);

    void UnMountFileSystem();

private:
    nn::os::MultiWaitHolderType* CreateEventHolder(nn::os::EventType *event, MoviePlayerSimpleEventType eventType);
    struct EventUserData
    {
        EventUserData(nn::os::EventType *event, MoviePlayerSimpleEventType eventType)
            : m_Event(event),
            m_EventType(eventType)
        { }
        nn::os::EventType *m_Event;
        MoviePlayerSimpleEventType m_EventType;
    };
    void DeleteEventUserData(EventUserData* userData);
    bool DoesMediaFileExists(char* mediaFileName);

    nn::vi::NativeWindowHandle m_NativeWindow;
    MoviePlayer                *m_MoviePlayer;
    char                       *m_MediaFile;
    nn::os::EventType          m_PlayerStateChangedEvent;
    nn::os::EventType          m_PlayerErrorEvent;

    nn::os::EventType          m_HidEventButtonPressA;
    nn::os::EventType          m_HidEventButtonPressB;
    nn::os::EventType          m_HidEventButtonPressX;
    nn::os::EventType          m_HidEventButtonPressZr;
    nn::os::EventType          m_HidEventButtonPressL;
    nn::os::EventType          m_HidEventButtonPressR;

    nn::os::MultiWaitHolderType m_PlayerStateChangedEventHolder;
    nn::os::MultiWaitHolderType m_PlayerErrorEventHolder;
    nn::os::MultiWaitHolderType m_HidEventButtonPressAHolder;
    nn::os::MultiWaitHolderType m_HidEventButtonPressBHolder;
    nn::os::MultiWaitHolderType m_HidEventButtonPressXHolder;
    nn::os::MultiWaitHolderType m_HidEventButtonPressZrHolder;
    nn::os::MultiWaitHolderType m_HidEventButtonPressLHolder;
    nn::os::MultiWaitHolderType m_HidEventButtonPressRHolder;

    MoviePlayer::State          m_State;
    nn::os::MultiWaitType       m_PlayerMultiWait;
    HidHandler                  *m_HidHandler;
    bool                        m_EventsInitialized;
    bool                        m_SdcardMounted;
    bool                        m_HostFsMounted;
    movie::DecoderMode          m_VideoDecoderMode;
    int64_t                     m_SeekSkipUnitUs;
};
