﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <cinttypes>
#include <cstring>
#include <movie/Utils.h>
#include <nn/nn_SdkLog.h>

namespace movie { namespace sample {

//
// The following is an example Visitor type that implements the movie::MediaData::Visitor interface.
// This interface can be used in conjunction with the movie::MediaData::Visit API to query the entries
// of a movie::MediaData instance. See the movie::MediaData::Visit documentation for more details.
//

class SamplePrintVisitor final : public movie::MediaData::Visitor {
public:
    void accept(const char* name_, int32_t i) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: int32_t : %s == %d\n", name_,i);
    }
    void accept(const char* name_, int64_t i) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: int64_t : %s == %" PRId64 "\n", name_,i);
    }
    void accept(const char* name_, size_t i) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: size_t : %s == %" PRIu64 "\n", name_,i);
    }
    void accept(const char* name_, float f) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: float : %s == %f\n", name_,f);
    }
    void accept(const char* name_, double d) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: double : %s == %f\n", name_,d);
    }
    void accept(const char* name_, void* ptr) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: void* : %s == %p\n", name_,ptr);
    }
    void accept(const char* name_, const char* c) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: const char* : %s == %s\n", name_,c);
    }
    void accept(const char* name_, movie::Buffer const& b) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: movie::Buffer : %s\n", name_);
    }
    void accept(const char* name_, int32_t left, int32_t top, int32_t right, int32_t bottom) const noexcept override {
        NN_SDK_LOG("SamplePrintVisitor: Rect : %s == {%d,%d,%d,%d}\n", name_,left,top,right,bottom);
    }
};

}} // namespace

