﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/mem/mem_StandardAllocator.h>

#include "HeapTracker.h"
#include <nn/fs.h>
#include "MediaPlayerSample.h"

nn::mem::StandardAllocator &GlobalAllocator();
HeapTracker &MMHeap();
HeapTracker &CoreHeap();
HeapTracker &MallocHeap();
HeapTracker &NewHeap();

void *mmAllocate(size_t size, size_t align, void *userPtr);
void mmDeallocate(void *address, void *userPtr);
void *mmReallocate(void* address, size_t newSize, void *userPtr);

// Memory functions remapped to MM heap
extern "C" void* malloc(size_t aSize);
extern "C" void free(void* aPtr);
extern "C" void* calloc(size_t aNum, size_t aSize);
extern "C" void* realloc(void* aPtr, size_t aNewSize);
extern "C" void* aligned_alloc(size_t aAlignment, size_t aSize);
void* operator new(::std::size_t aSize, const ::std::nothrow_t&) throw();
void* operator new[](::std::size_t aSize, const ::std::nothrow_t&) throw();
void* operator new(::std::size_t aSize) throw(::std::bad_alloc);
void* operator new[](::std::size_t aSize) throw(::std::bad_alloc);
void operator delete(void* aPtr) throw();
void operator delete[](void* aPtr) throw();

bool ProcessConfigFile(const char *file);
bool ProcessUrlFile(const char *file, std::string *str);
