﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <upnp/upnp.h>
#include <upnp/upnptools.h>
#include <upnp/upnpdebug.h>

#include <cstdio>
#include <cstdlib>

namespace nns {
namespace libupnp {

const int UpnpDeviceGameMaxVars = 3;
const int UpnpDeviceGameVarLength = 5;

enum UpnpDeviceGameColor
{
    UpnpDeviceGameColor_Min    = 0,
    UpnpDeviceGameColor_Grey   = 0,
    UpnpDeviceGameColor_Green  = 1,
    UpnpDeviceGameColor_Orange = 2,
    UpnpDeviceGameColor_Red    = 3,
    UpnpDeviceGameColor_Blue   = 4,
    UpnpDeviceGameColor_Yellow = 5,
    UpnpDeviceGameColor_Indigo = 6,
    UpnpDeviceGameColor_Violet = 7,
    UpnpDeviceGameColor_Max    = 7
};

class UpnpDeviceGame
{
public:
    static const char*   DeviceType;
    static const char*   ServiceType;

    static const char*   VariableNames[UpnpDeviceGameMaxVars];
    static const char*   ActionSetNames[UpnpDeviceGameMaxVars];
    static const char*   ActionGetNames[UpnpDeviceGameMaxVars];

    char*                m_VariableValues[UpnpDeviceGameMaxVars];
    char                 m_VariableValuesDef[UpnpDeviceGameMaxVars][UpnpDeviceGameVarLength];

    IXML_NodeList*       GetNthServiceList(IXML_Document* pDesc, unsigned int servicePos) NN_NOEXCEPT;
    int                  GetFirstElementItem(char* pOutItem, size_t outSize, IXML_Element* pElement, const char* pItem) NN_NOEXCEPT;
    int                  GetFirstDocumentItem(char* pOutItem, size_t outSize, IXML_Document* pDesc, const char* pItem) NN_NOEXCEPT;
    int                  GetElementValue(char* pOutItem, size_t outSize, IXML_Element* pElement) NN_NOEXCEPT;
};

}} // namespace nns / libupnp

