﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <upnp/upnp.h>
#include <upnp/upnpdebug.h>
#include <upnp/upnptools.h>

#include <cstdio>
#include <cstdlib>

#include <map>
#include <string>

namespace nns {
namespace libupnp {

class UpnpLanDevice
{
public:
    char    m_Udn[200];
    char    m_DeviceType[200];
    char    m_FriendlyName[200];
    char    m_BaseUrl[200];
    char    m_RelativeUrl[200];
    char    m_PresentationUrl[200];
    char    m_WanControlUrl[200];
    int     m_AdvertiseTimeout;

    UpnpLanDevice() NN_NOEXCEPT;
    UpnpLanDevice(const UpnpLanDevice& rhs) NN_NOEXCEPT;
    ~UpnpLanDevice() NN_NOEXCEPT;

    UpnpLanDevice&    operator=(const UpnpLanDevice& rhs) NN_NOEXCEPT;
};


class UpnpIGWDevices
{
private:
    std::map<std::string,UpnpLanDevice>    m_Map;
    nn::os::MutexType                      m_MapMutex;

public:
    static const char*                     IGWDeviceType;
    static const char*                     IGWWANIPConnection;

    UpnpIGWDevices() NN_NOEXCEPT;
    ~UpnpIGWDevices() NN_NOEXCEPT;

    size_t         GetMapSize() NN_NOEXCEPT;
    int            AddDevice(IXML_Document* pDescDoc, struct Upnp_Discovery* pDiscovery, bool* isIGWDevice) NN_NOEXCEPT;
    int            GetDevice(UpnpLanDevice& lanDevice) NN_NOEXCEPT;

    IXML_NodeList* GetNthServiceList(IXML_Document* pDesc, unsigned int servicePos) NN_NOEXCEPT;
    int            GetFirstElementItem(char* pOutItem, size_t outSize, IXML_Element* pElement, const char* pItem) NN_NOEXCEPT;
    int            GetFirstDocumentItem(char* pOutItem, size_t outSize, IXML_Document* pDesc, const char* pItem) NN_NOEXCEPT;
};

}}  // namespace nns / libupnp
