﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "Pad.h"

namespace nns { namespace ldn
{
    /**
     * @brief           デバッグパッドです。
     */
    class DebugPad : public IPad
    {
    public:

        /**
         * @brief           コンストラクタです。
         */
        DebugPad() NN_NOEXCEPT;

        /**
         * @brief           デストラクタです。
         */
        virtual ~DebugPad() NN_NOEXCEPT;

        virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

        virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

        virtual void Update(PadState* pOutState) NN_NOEXCEPT NN_OVERRIDE;

    private:

        uint16_t m_PreviousButtonState;
        bool m_IsInitialized;
    };

}} // namespace nns::ldn


