﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/hid.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/irsensor.h>
#include <nn/irsensor/irsensor_MarkerPositionReader.h>

#include "GraphicsSystem.h"

enum IrSensorMode {
    IrSensorMode_PositionReader = 0,
    IrSensorMode_Count = 1,
};

struct Texture
{
    nn::gfx::Texture texture;
    nn::gfx::TextureView view;
    nn::gfx::DescriptorSlot descriptor;
};

struct Sampler
{
    nn::gfx::Sampler sampler;
    nn::gfx::DescriptorSlot descriptor;
};

void CreateTexture(GraphicsSystem* pGraphicsSystem, int width, int height, nn::gfx::ImageFormat format, Texture* pTexture);
void CreateSampler(GraphicsSystem* pGraphicsSystem, Sampler* pSampler);

class IrSensorModeState;

struct IrSensorDemo
{
public:
    void Initialize(nn::hid::NpadIdType id, GraphicsSystem* pGraphicsSystem, void* pImageTransferWorkMemory);
    void Finalize();
    void CheckFirmwareUpdate(const nn::irsensor::IrCameraHandle& handle) NN_NOEXCEPT;
    bool Run(int i, GraphicsSystem* pGraphicsSystem, nn::gfx::util::DebugFontTextWriter* pTextWriter) NN_NOEXCEPT;
    bool ProcessGamePad() NN_NOEXCEPT;

protected:
    int GetMenuIndex() const;

private:
    IrSensorMode                     m_CurrentProcessor{};
    IrSensorMode                     m_NextProcessor{};
    nn::hid::NpadIdType              m_NpadId;
    nn::irsensor::IrCameraHandle     m_IrCameraHandle{};
    int                              m_MenuSelection{};
    nn::hid::NpadJoyRightState       m_PreviousPadState{};
    IrSensorModeState*               m_ModeStates[IrSensorMode_Count];
};
