﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/hid/system/hid_Result.h>

#include "HidSixAxisSensorAccurateCalibration_CalibratingState.h"
#include "HidSixAxisSensorAccurateCalibration_State.h"

CalibratingState::CalibratingState() NN_NOEXCEPT
{
    // 何もしない
}

CalibratingState::~CalibratingState() NN_NOEXCEPT
{
    // 何もしない
}

void CalibratingState::Update(Context* pContext) NN_NOEXCEPT
{
    const auto TriggerButtons = pContext->GetTriggerButtons();

    pContext->PrintCalibrationStatus();

    if (TriggerButtons.Test<::nn::hid::NpadButton::B>())
    {
        // InitialState に遷移
        pContext->SetState(&State::s_InitialState);
    }
}

void CalibratingState::Enter(Context* pContext) NN_NOEXCEPT
{
    NN_LOG("[%s] CalibratingState\n", __FUNCTION__);
}

void CalibratingState::Exit(Context* pContext) NN_NOEXCEPT
{
    NN_LOG("[%s] CalibratingState\n", __FUNCTION__);
}
