﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/hid_NpadJoy.h>

#include "HidNpadIntegrate_PluginManager.h"
#include "HidNpadIntegrate_SettingApi.h"
#include "HidNpadIntegrate_SettingApiPluginBase.h"

class SwapNpadAssignmentApiState : public SettingApiPluginBase
{
    NN_DISALLOW_COPY(SwapNpadAssignmentApiState);
    NN_DISALLOW_MOVE(SwapNpadAssignmentApiState);

public:
    SwapNpadAssignmentApiState() NN_NOEXCEPT {}

    ~SwapNpadAssignmentApiState() NN_NOEXCEPT NN_OVERRIDE {}

    void Initialize(int* pNextProcessor, int* pMenuSelection) NN_NOEXCEPT NN_OVERRIDE
    {
        SettingApiPluginBase::Initialize(pNextProcessor, pMenuSelection);
        m_NpadId1 = 0;
        m_NpadId2 = 0;
        m_pNpadIdType1 = new NpadIdType(&m_NpadId1);
        MenuItem npadIdType1MenuItem("  NpadID1", m_pNpadIdType1);
        m_ReadWriteMenu.push_back(npadIdType1MenuItem);

        m_pNpadIdType2 = new NpadIdType(&m_NpadId2);
        MenuItem npadIdType2MenuItem("  NpadID2", m_pNpadIdType2);
        m_ReadWriteMenu.push_back(npadIdType2MenuItem);
    }

    void Finalize() NN_NOEXCEPT NN_OVERRIDE
    {
        delete m_pNpadIdType1;
        delete m_pNpadIdType2;
        SettingApiPluginBase::Finalize();
    }

    void Start() NN_NOEXCEPT NN_OVERRIDE
    {
        nn::hid::SwapNpadAssignment(m_NpadId1, m_NpadId2);
        m_ResultMsg = "Success";
    }

    void Explain(
        nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        pTextWriter->SetTextColor(Color::White);
        pTextWriter->SetScale(1.0f, 1.0f);

        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->
            Print("This function swaps connection of Npad and controller between two Npads.");
        pTextWriter->SetCursor(OffsetX, OffsetY + 30);
        pTextWriter->
            Print("If NpadID1 is connected with a controller and NpadID2 has no connection,");
        pTextWriter->SetCursor(OffsetX, OffsetY + 60);
        pTextWriter->
            Print("the controller connected with NpadID1 will be connected with NpadID2.");
    }

    bool DrawAssignment(
        int index, nn::gfx::util::DebugFontTextWriter* pTextWriter,
        const float OffsetX, const float OffsetY) NN_NOEXCEPT NN_OVERRIDE
    {
        pTextWriter->SetCursor(OffsetX, OffsetY);
        pTextWriter->Print("AssignmentMode: %s",
            nn::hid::GetNpadJoyAssignment(NpadIds[index]) == nn::hid::NpadJoyAssignmentMode_Dual ?
            "Dual" : "Single");

        return true;
    }

private:
    nn::hid::NpadIdType m_NpadId1;
    nn::hid::NpadIdType m_NpadId2;
    ReadWriteBase* m_pNpadIdType1;
    ReadWriteBase* m_pNpadIdType2;
};

namespace {
SET_PLUGIN(SwapNpadAssignmentApiState, "SwapNpadAssignment");
}
