﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nv/nv_MemoryManagement.h>

#include "HidNpadIntegrate_Main.h"
#include "HidNpadIntegrate_PluginBase.h"
#include "HidNpadIntegrate_PluginManager.h"

namespace {

#if defined(NN_BUILD_TARGET_PLATFORM_NX)
    void* NvAllocate(size_t size, size_t alignment, void* userPtr) NN_NOEXCEPT
    {
        NN_UNUSED(userPtr);
        return aligned_alloc(alignment, nn::util::align_up(size, alignment));
    }

    void NvFree(void* addr, void* userPtr) NN_NOEXCEPT
    {
        NN_UNUSED(userPtr);
        free(addr);
    }

    void* NvReallocate(void* addr, size_t newSize, void* userPtr) NN_NOEXCEPT
    {
        NN_UNUSED(userPtr);
        return realloc(addr, newSize);
    }
#endif

}

class PlatformDependentForNx : public PlatformDependentPluginBase
{
    NN_DISALLOW_COPY(PlatformDependentForNx);
    NN_DISALLOW_MOVE(PlatformDependentForNx);

public:
    PlatformDependentForNx() NN_NOEXCEPT {}

    virtual ~PlatformDependentForNx() NN_NOEXCEPT NN_OVERRIDE{}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE
    {
#if defined(NN_BUILD_TARGET_PLATFORM_NX)
        const size_t GraphicsMemorySize = 8 * 1024 * 1024;
        nv::SetGraphicsAllocator(NvAllocate, NvFree, NvReallocate, NULL);
        nv::SetGraphicsDevtoolsAllocator(NvAllocate, NvFree, NvReallocate, NULL);
        nv::InitializeGraphics(std::malloc(GraphicsMemorySize), GraphicsMemorySize);
#endif
    }

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Run() NN_NOEXCEPT NN_OVERRIDE {}


};

SET_PLUGIN(PlatformDependentForNx, "PlatformDependentForNx");
