﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs.h>
#include <nns/gfx/gfx_GraphicsFramework.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/init/init_Malloc.h>
#include <nn/oe.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_ControllerSupport.h>
#include <nn/hid/hid_NpadColor.h>

#include <nns/hid.h>

#include <nns/hid/hid_GamePadNx.h>
#include <nns/hid/hid_GamePadNxAsset.h>
#include "./HidControllerSequence_GraphicsSystem.h"
#include "./HidControllerSequence_Thread.h"
#include "./HidControllerSequence_ControllerSupportApplet.h"

#if defined(NN_BUILD_TARGET_PLATFORM_NX)
#include <nv/nv_MemoryManagement.h>
#endif

extern nns::hid::ControllerManager* g_pControllerManager;
extern ::GraphicsSystem*            g_pGraphicsSystem;

enum ResourceType
{
    ResourceType_Title = 0,
    ResourceType_StyleIcon,
    ResourceType_ButtonIcon,
    ResourceType_Num
};
extern nn::gfx::ResTextureFile*     g_pResTextureFile;
extern int32_t                      g_TextureIndex[ResourceType_Num];
extern nn::gfx::DescriptorSlot      g_TextureDescriptor[ResourceType_Num];
extern nn::gfx::DescriptorSlot      g_ScanScreenDescriptor;
extern nn::gfx::DescriptorSlot      g_SamplerDescriptor;
extern nn::gfx::Sampler             g_Sampler;

class ApplicationState
{
public:
    static const size_t                 MaxPlayerCount = 4;
    static const nn::hid::NpadIdType    NpadIds[(MaxPlayerCount + 1)];
    static nn::hid::NpadAttributesSet   InitialConnectedController[(MaxPlayerCount + 1)];       //!< ゲーム開始時に接続されているNpadIdリスト
private:
    static size_t                       s_PlayerCount;
    static bool                         s_IsHandheldMode;
public:
    static bool IsHandheldMode() { return s_IsHandheldMode; }
    static void EnableHandheldMode(bool isEnable = true) { s_IsHandheldMode = isEnable; }
    static size_t GetPlayerCount() { return s_PlayerCount; }
    static void SetPlayerCount(size_t count) { s_PlayerCount =  std::min(count, MaxPlayerCount); }
};


//extern const nn::hid::NpadIdType    g_NpadIds[5];
//extern nn::hid::NpadAttributesSet   g_ConnectedController[5];   //!< ゲーム開始時に接続されているNpadId (g_NpadIdsと対応)
//
//extern const int32_t                g_MaxPlayerCount;           //!< 最大のプレイヤー人数
//extern int32_t                      g_PlayerCount;              //!< プレイヤー人数
//extern const int                    g_FrameRate;                //!< フレームレート
//extern bool                         g_isHandheldMode;           //!< 本体装着コントローラーを使用しているか否か

extern const int                    g_FrameRate;                //!< フレームレート
extern nn::os::MutexType            g_Mutex;

void ThreadFunc(void* arg);

void* ReadResource(nn::mem::StandardAllocator* memory, const char* filename);

void InitializeResource(GraphicsSystem* system, nn::mem::StandardAllocator* memory);

void InitializeSampler(GraphicsSystem* system);

void DrawStyleIcon(const nn::util::Float2& pos, const nn::util::Float2& size, int32_t iconIndex);

void FeedOut(void* arg);
