﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "./HidControllerSequence_Dialog.h"
#include "./HidControllerSequence_Main.h"

//! @brief プレイヤーのステータス
struct PlayerState
{
    nn::util::Float2        Pos;            //!< 表示座標
    nn::util::Float2        Size;           //!< 表示サイズ
    nn::util::Color4u8      Color;          //!< プレイヤーカラー
    nn::hid::NpadStyleSet   Style;          //!< プレイヤーの操作するコントローラーのスタイル
    nn::hid::NpadIdType     Id;             //!< プレイヤーの操作するコントローラーのID
};


//! @brief アニメーション用カウンタ
struct AnimationCounter
{
    bool IsStart;                           //!< カウントを開始しているか
    uint64_t StartFrameCount;               //!< 開始時のフレームカウント
    uint64_t CurFrameCount;                 //!< 現在のフレームカウント

    AnimationCounter() :
        IsStart(false),
        StartFrameCount(0),
        CurFrameCount(0)
    {
    }
};

//! @brief プレイヤー
class Player
{
public:
    static const nn::util::Float4       MoveArea;              //!< 移動できる範囲 (左上の座標,と右下の差表)
    static const float                  MaxSpeed;              //!< ダッシュ状態でない時のプレイヤーの最大加速度
    static const nns::hid::ButtonSet    MoveButtonSet;         //!< プレイヤーが動作するボタン
private:
    uint64_t                            m_FrameCount;
    AnimationCounter                    m_AnimeCounter;
    PlayerState                         m_State;
    nn::util::Float2                    m_Scale;
    nn::util::Float2                    m_Accel;
    bool                                m_isShowInfo;
public:
    NN_IMPLICIT Player(const PlayerState& state);
    void Update();
    void Draw(nn::gfx::CommandBuffer* command, nns::gfx::PrimitiveRenderer::Renderer* renderer);
    void DrawInfo();
    PlayerState GetState();
    void SetNpadId(nn::hid::NpadIdType id);
    void Move(const nns::hid::Controller& controller);
};

class GameSceneThread : public ThreadState
{
public:

private:
    DialogInfo              m_PauseDialog;
    DialogInfo              m_ControllerLostDialog;

    bool                    m_IsSingleMode;
    std::vector<Player*>    m_PlayerList;

    nns::gfx::PrimitiveRenderer::Renderer*  m_pRenderer;
    nn::gfx::util::DebugFontTextWriter*     m_pTextWriter;
    nn::gfx::CommandBuffer*                 m_pCommand;
public:
    GameSceneThread();
    GameSceneThread(const char* name, nn::os::ThreadFunction func);

    void Initialize();
    void Update();
    void Draw();
    void Finalize();

    // ダイアログを初期化します
    void InitializeDialog();
    // ポーズ画面のダイアログを呼び出します
    void CallDialog(const nn::hid::NpadIdType& npadId);
    // 画面をぼかします
    void BlurScreen();
};
