﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>

#include <nn/vi.h>
#include <nn/gll.h>

#include "GraphicsHelper.h"

namespace
{
    nn::vi::Display* g_pDisplay = nullptr;
    nn::vi::Layer* g_pLayer = nullptr;
    nn::vi::NativeWindowHandle g_hNativeWindow = nullptr;

    HDC g_hDc = nullptr;
    HGLRC g_hGlRc = nullptr;
}

void GraphicsHelper::Initialize()
{
    nn::vi::Initialize();

    nn::Result result;
    NN_UNUSED( result );

    result = nn::vi::OpenDefaultDisplay( &g_pDisplay );
    NN_ASSERT( result.IsSuccess() );

    result = nn::vi::CreateLayer( &g_pLayer, g_pDisplay );
    NN_ASSERT( result.IsSuccess() );

    nn::vi::SetLayerScalingMode( g_pLayer, nn::vi::ScalingMode_FitToLayer );

    result = nn::vi::GetNativeWindow( &g_hNativeWindow, g_pLayer );
    NN_ASSERT( result.IsSuccess() );

    BOOL wglResult;
    NN_UNUSED( wglResult );

    g_hDc = ::GetDC( static_cast< HWND >( g_hNativeWindow ) );
    NN_ASSERT_NOT_NULL( g_hDc );

    g_hGlRc = ::wglCreateContext( g_hDc );
    NN_ASSERT_NOT_NULL( g_hGlRc );

    wglResult = ::wglMakeCurrent( g_hDc, g_hGlRc );
    NN_ASSERT_EQUAL( wglResult, TRUE );

    nngllResult gllResult;
    NN_UNUSED( gllResult );
    gllResult = nngllInitializeWgl();
    NN_ASSERT_EQUAL( gllResult, nngllResult_Succeeded );

    // 関数ポインタが null かどうかを調べることにより、その関数がロードされているかどうかを判定できます。
    if( ::wglCreateContextAttribsARB != nullptr )
    {
        const int attribs[] =
        {
            WGL_CONTEXT_MAJOR_VERSION_ARB, 4,
            WGL_CONTEXT_MINOR_VERSION_ARB, 5,
            WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_CORE_PROFILE_BIT_ARB,
            WGL_CONTEXT_FLAGS_ARB, 0,
            0
        };

        HGLRC hNewGlRc = ::wglCreateContextAttribsARB( g_hDc, nullptr, attribs );
        if( hNewGlRc )
        {
            wglResult = ::wglMakeCurrent( NULL, NULL );
            NN_ASSERT_EQUAL( wglResult, TRUE );
            wglResult = ::wglDeleteContext( g_hGlRc );
            NN_ASSERT_EQUAL( wglResult, TRUE );
            g_hGlRc = hNewGlRc;
            wglResult = ::wglMakeCurrent( g_hDc, g_hGlRc );
            NN_ASSERT_EQUAL( wglResult, TRUE );
        }
    }
}

void GraphicsHelper::Finalize()
{
    BOOL wglResult;
    NN_UNUSED( wglResult );
    wglResult = ::wglMakeCurrent( nullptr, nullptr );
    NN_ASSERT_EQUAL( wglResult, TRUE );
    wglResult = ::wglDeleteContext( g_hGlRc );
    NN_ASSERT_EQUAL( wglResult, TRUE );

    ReleaseDC( static_cast< HWND >( g_hNativeWindow ), g_hDc );

    nn::vi::DestroyLayer( g_pLayer );
    nn::vi::CloseDisplay( g_pDisplay );
    nn::vi::Finalize();
}

void GraphicsHelper::SwapBuffers()
{
    ::SwapBuffers( g_hDc );
}

