﻿/// <tag name="Input">
///   <func id="GetAlbedoTexture0"/>
/// </tag>
/// <func id="GetAlbedoTexture0" name="GetAlbedoTexture0" is_macro="true">
///   <out name="output" type="vec4"/>
///   <description>アルベドテクスチャー 0</description>
/// </func>
/// <block guid="{2950E21B-22DF-4811-B3C8-FE20923294F6}" displayname="AlbedoTexture0">
///   <func id="GetAlbedoTexture0"/>
///   <out displayname="output" type="vec4" target="output"/>
/// </block>
/// <code>
#define GetAlbedoTexture0( output )\
{\
    vec4 albedo = vec4(1, 1, 1, 1);\
    if (NN_G3D_TO_BOOL(USE_ALBEDO_TEX))\
    {\
        albedo = texture(albedoTex0, IN.uv0_uv1.xy);\
    }\
\
    output = albedo;\
}
/// </code>

/// <tag name="Input">
///   <func id="GetAlbedoTexture1"/>
/// </tag>
/// <func id="GetAlbedoTexture1" name="GetAlbedoTexture1" is_macro="true">
///   <out name="output" type="vec4"/>
///   <description>アルベドテクスチャー 1</description>
/// </func>
/// <block guid="{2950E21B-22DF-4811-B3C8-FE20923294F7}" displayname="AlbedoTexture1">
///   <func id="GetAlbedoTexture1"/>
///   <out displayname="output" type="vec4" target="output"/>
/// </block>
/// <code>
#define GetAlbedoTexture1( output )\
{\
    vec4 albedo1 = texture(albedoTex1, IN.uv0_uv1.zw);\
    output = albedo1;\
}
/// </code>

/// <tag name="Output0">
///   <func id="SetOutputColor0"/>
/// </tag>
/// <func id="SetOutputColor0" name="SetOutputColor0" is_macro="true">
///   <in name="color0" type="vec4"/>
///   <description>出力 Color 0</description>
/// </func>
/// <block guid="{DC38CA9A-E635-479F-AEF6-EC5D7DD5A45E}" displayname="OutputColor0">
///   <func id="SetOutputColor0"/>
///   <in displayname="Color0" type="vec4" target="color0"/>
/// </block>
/// <code>
#define SetOutputColor0( color0 )\
{\
    combiner_output_color = color0;\
}
/// </code>

/// <tag name="Output1">
///   <func id="SetOutputColor1"/>
/// </tag>
/// <func id="SetOutputColor1" name="SetOutputColor1" is_macro="true">
///   <in name="color1" type="vec4"/>
///   <description>出力 Color 1</description>
/// </func>
/// <block guid="{DC38CA9A-E635-479F-AEF6-EC5D7DD5A450}" displayname="OutputColor1">
///   <func id="SetOutputColor1"/>
///   <in displayname="Color1" type="vec4" target="color1"/>
/// </block>
/// <code>
#define SetOutputColor1( color1 )\
{\
    combiner_output_color = color1;\
}
/// </code>

