# -*- coding: utf-8 -*-
from __future__ import print_function
from abc import ABCMeta, abstractmethod

from HACDllDriver import HACDriverDll

class IScene:
    """
    G3dDemo の各シーンで自動操縦行うための基底クラス
    """

    __metaclass__ = ABCMeta

    def CheckValidControllerId(self, driver, debugPadId):
        if debugPadId in range(0,len(driver.controllers)):
            raise Exception("Invalid debugpadId: %d"%[debugPadId])

    @abstractmethod
    def Execute(self, driver, debugPadId):
        print("abstract")
        