﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../HostExecutableFilepath.h"

#include <cstring>
#include <nn/nn_Assert.h>

#pragma warning(push)
#pragma warning(disable: 4668)
#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <nn/nn_Windows.h>
#pragma warning(pop)

namespace nns
{
    const char* HostExecutableFilepath::GetDirectoryPath() NN_NOEXCEPT
    {
        // 作業パスの最大長。
        static const int MaxPathLength = 512;
        // 取得したパスから上がるディレクトリの数（含 filename ）。
        static const int RemoveNestDepth = 1;

        static char s_Path[ MaxPathLength ] = {};

        if(s_Path[0] != '\0')
        {
            return s_Path;
        }

        // 実行ファイルのパスを取得
        const int filepathLength = GetModuleFileNameA(NULL, s_Path, MaxPathLength);
        NN_ASSERT( filepathLength < MaxPathLength );
        NN_ASSERT( GetLastError() == ERROR_SUCCESS );

        // ディレクトリ名を取得
        {
            int pos = filepathLength - 1;
            for(; pos >= 0; pos-- )
            {
                if( s_Path[pos] == '/' || s_Path[pos] == '\\' )
                {
                   s_Path[pos] = '\0';
                   break;
                }
            }
            NN_ASSERT(pos > 0);
        }

        return s_Path;
    }

}// namespace detail
