﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>

#include <nn/hid.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/hid/hid_KeyboardKey.h>
#include <nn/hid/hid_Npad.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Thread.h>
#include <nn/TargetConfigs/build_Platform.h>

#include "Demo1ScenePluginBase.h"

class TouchScreenDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(TouchScreenDemo);
    NN_DISALLOW_MOVE(TouchScreenDemo);
public:
    TouchScreenDemo() NN_NOEXCEPT {}

    virtual ~TouchScreenDemo() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Start() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void End() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Procedure() NN_NOEXCEPT NN_OVERRIDE {}

    virtual void Draw() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Wait() NN_NOEXCEPT NN_OVERRIDE {}

private:
    void MakeCommand(int64_t frame, const char* pName) NN_NOEXCEPT;
};
