﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

/**
* @brief hand analysis utilityにて使用する構造体
*/
struct PolygonProperties
{
    float perimeter;   // ポリゴンの外周

    // ポリゴンの符号付面積。ポリゴンが直接である場合、この領域は正です。
    // ポリゴンが間接的である場合、領域は負です。
    float signedArea;

    nn::util::Float2 perimeterCentroid; //  ポリゴンの外周上にある点の重心

    // ポリゴン内部の点の重心は、直接囲まれている場合1によって重み
    // 付けされ、間接的に囲まれている場合は-1によって重みづけされる
    nn::util::Float2 areaCentroid;
};

// ポリゴン特性の算出
void ComputePolygonProperties(
    PolygonProperties* pPolygonProperties,
    nn::util::Float2 const* pPolygonPoints,
    size_t polygonPointCount) NN_NOEXCEPT;


// 与えられた点からExtractConvexHullを抽出
void ExtractConvexHull(
    std::vector<size_t>& convexHullIndices,
    const std::vector<nn::util::Float2>& oneTurnSilhouette) NN_NOEXCEPT;

