﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include "Demo1ScenePluginBase.h"

class GfxDemo : public ScenePluginBase
{
    NN_DISALLOW_COPY(GfxDemo);
    NN_DISALLOW_MOVE(GfxDemo);
public:
    GfxDemo() NN_NOEXCEPT
        : m_pResTextureFile(NULL)
        , m_IndexBg(-1)
        , m_IndexText(-1)
        , m_pMemoryHeap(NULL)
        , m_pMemory(NULL)
    {
    };
    virtual ~GfxDemo() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Start() NN_NOEXCEPT NN_OVERRIDE;
    virtual void End() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Draw() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Wait() NN_NOEXCEPT NN_OVERRIDE;

private:
    static const size_t ThreadStackSize = 128 * 1024;

private:
    void MakeCommand(int64_t frame, const char* pName) NN_NOEXCEPT;
    static void GfxThreadFunc(void* pArg) NN_NOEXCEPT;
    void GfxThreadFuncImpl() const NN_NOEXCEPT;

    void* ReadResource(const char* pFilename) NN_NOEXCEPT;
    void InitializeInvisibleMemoryPool() NN_NOEXCEPT;
    void InitializeResTextureFile() NN_NOEXCEPT;
    void FinalizeResTextureFile() const NN_NOEXCEPT;
    void InitializeResources() NN_NOEXCEPT;
    void FinalizeResources() const NN_NOEXCEPT;
    void InitializeUserShader() NN_NOEXCEPT;
    bool InitializeMesh(
        nns::gfx::PrimitiveRenderer::PrimitiveMesh& meshBuffer,
        bool bUseVertexColor
    ) const NN_NOEXCEPT;
    void InitializeIndexBuffer(
        nns::gfx::PrimitiveRenderer::PrimitiveMesh& meshBuffer) const NN_NOEXCEPT;
    void InitializeVertexBuffer(
        nns::gfx::PrimitiveRenderer::PrimitiveMesh& meshBuffer,
        bool bUseVertexColor) const NN_NOEXCEPT;
    bool DrawUserMesh(
        nn::util::Matrix4x3f& modelMatrix,
        bool bUseVertexColor,
        int64_t frame) const NN_NOEXCEPT;
    void DrawTexture(
        nn::util::Matrix4x3f& modelMatrix,
        nn::gfx::DescriptorSlot& textureDescriptor,
        nn::gfx::DescriptorSlot& samplerDescriptor) const NN_NOEXCEPT;
    void SetViewMatrix(int64_t frame) const NN_NOEXCEPT;
    void InitProjection() const NN_NOEXCEPT;
    void DrawAxis() const NN_NOEXCEPT;
    void DrawCircle(nn::util::Matrix4x3f& modelMatrix) const NN_NOEXCEPT;
    void DrawTriangle(nn::util::Matrix4x3f& modelMatrix) const NN_NOEXCEPT;
    void DrawCube(nn::util::Matrix4x3f& modelMatrix) const NN_NOEXCEPT;
    void DrawQuad(
        nn::util::Matrix4x3f& modelMatrix,
        nn::gfx::DescriptorSlot& textureDescriptor,
        nn::gfx::DescriptorSlot& samplerDescriptor) const NN_NOEXCEPT;
    void DrawShere(nn::util::Matrix4x3f& modelMatrix) const NN_NOEXCEPT;
    void DrawCone(nn::util::Matrix4x3f& modelMatrix) const NN_NOEXCEPT;
    void DrawCapsule(nn::util::Matrix4x3f& modelMatrix) const NN_NOEXCEPT;
    void DrawObjects(
        int64_t frame,
        nn::gfx::DescriptorSlot& textureDescriptor,
        nn::gfx::DescriptorSlot& samplerDescriptor) const NN_NOEXCEPT;

private:
    nn::os::ThreadType  m_GfxThread;

    nn::gfx::TextureView m_ColorTextureView;
    nn::gfx::ResTextureFile* m_pResTextureFile;

    int m_IndexBg;
    int m_IndexText;

    char*  m_pThreadStack;

    int m_TextureDescriptorIndex0;
    int m_TextureDescriptorIndex1;

    nn::util::BytePtr m_pMemoryHeap;
    nn::util::BytePtr m_pMemory;
};
