﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ConsoleSimple.h"

#include <nns/console/console_ConsoleManager.h>
#include <nns/console/console_InputManager.h>

namespace
{
// コンソールとその描画を管理するための領域。巨大&アラインメントの制約があるので基本的に名前空間直下に配置する。
nns::console::DefaultConsoleManagerHolder g_ManagerHolder = NNS_CONSOLE_CONSOLE_MANAGER_HOLDER_INITIALIZER;
} // ~namespace <anonymous>

extern "C" void nnMain()
{
    // コンソールマネージャと HID の初期化
    auto& manager = g_ManagerHolder.GetManager();
    nns::console::DefaultInputManager im;
    im.Initialize();

    // サンプル実装の初期化
    TypeWriter typeWriter;
    typeWriter.Initialize(&manager, &im);

    // 処理と描画
    while (NN_STATIC_CONDITION(true))
    {
        im.Update();
        manager.Update();
        manager.Draw();
    }
}
