﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>
#include <nn/bluetooth/bluetooth_Result.public.h>
#include <nn/bluetooth/bluetooth_Result.private.h>

class myBtClient : public bluetoothClient
{
    public:


    private:

    void EventFromConnectionStateCallback(const nn::bluetooth::InfoFromConnectionStateCallback* pInfo)
    {
        bluetoothClient::EventFromConnectionStateCallback(pInfo);

        if(pInfo->state==nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            setTsi(pInfo->bluetoothAddress, 10);
        }
    }

};


static myBtClient client;


//-----------------------------------------------------------------------------
void waitLoop(int count)
{
    while(count > 0)
    {
        NN_LOG("%d..", count--);
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000));
    }
    NN_LOG("0\n");
}

//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("NBM_CLIENT NOW RUNNING \n");


    client.startBluetooth();

    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(5000));
    nn::bluetooth::StartDiscovery();

    for(int k=0; k<10; k++)
    {
        nn::Result result;
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Iteration %d\n", k);

        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Waiting for Controller to connect\n");
        while (!client.controllerInfo[0].valid || client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            NN_LOG("\t\tPlease connect a controller...\n");
            nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(2000));
        }
        NN_LOG("\t\t[PASS]Controller connected\n");
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(2000));



        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should disconnect in ");
        waitLoop(2);
        nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(2000));



        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Controller should re-connect in ");
        waitLoop(2);
        result = nn::bluetooth::HidWakeController(&client.controllerInfo[0].bdAddr);
        if (result.IsFailure()) {
            NN_LOG("\t\t[FAIL]HidWakeController return %d, should be 0\n", result.GetDescription());
        }
        int waitTime = 0;
        const int MAX_WAIT_MS = 3000;
        while (waitTime < MAX_WAIT_MS && client.controllerInfo[0].connectState != nn::bluetooth::BTHH_CONN_STATE_CONNECTED) {
            nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(10));
            waitTime += 10;
        }
        if (waitTime < MAX_WAIT_MS) {
            NN_LOG("\t\t[PASS]Controller woke-up in %d ms\n", waitTime);
        } else {
            NN_LOG("\t\t[FAIL]Failed to wake controller in %d ms\n", waitTime);
        }
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(2000));


        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Attempting to wake-up a connected controller\n");
        result = nn::bluetooth::HidWakeController(&client.controllerInfo[0].bdAddr);
        if (result.GetDescription() != ResultConnectionError().GetDescription()) {
            NN_LOG("\t\t[FAIL]HidWakeController returned %d, expected %d>\n",
                    result.GetDescription(), ResultConnectionError().GetDescription());
        } else {
            NN_LOG("\t\t[PASS]Got ResultConnectionError()\n");
        }
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(3000));


        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Attempting to wake-up a bogus controller -- bd_addr(0,0,0,0,0,0)\n");
        nn::bluetooth::BluetoothAddress allZeroAddress = {{ 0, 0, 0, 0, 0, 0 }};
        result = nn::bluetooth::HidWakeController(&allZeroAddress);
        if (result.GetDescription() != ResultBadParameter().GetDescription()) {
            NN_LOG("\t\t[FAIL]HidWakeController returned %d, expected %d>\n",
                    result.GetDescription(), ResultBadParameter().GetDescription());
        } else {
            NN_LOG("\t\t[PASS]Got ResultBadParameter()\n");
        }
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(3000));


        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Attempting to wake-up a bogus controller -- bd_addr(1,2,3,4,5,6)\n");
        nn::bluetooth::BluetoothAddress nonExistentAddress = {{ 1, 2, 3, 4, 5, 6 }};
        result = nn::bluetooth::HidWakeController(&nonExistentAddress);
        if (result.GetDescription() != ResultBadParameter().GetDescription()) {
            NN_LOG("\t\t[FAIL]HidWakeController returned %d, expected %d>\n",
                    result.GetDescription(), ResultBadParameter().GetDescription());
        } else {
            NN_LOG("\t\t[PASS]Got ResultBadParameter()\n");
        }
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(3000));
    }

    nn::bluetooth::HidDisconnect(&client.controllerInfo[0].bdAddr);
    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000));
    client.finishBluetooth();
}



