﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "bluetooth_Client.h"
#include <cstdlib>

static enum {
    SETGET_INIT,
    SETGET_READY_TO_SEND_SET,
    SETGET_WAIT_FOR_SET_STATUS,
    SETGET_READY_TO_SEND_GET,
    SETGET_WAIT_FOR_GET_STATUS
} stateForSetGet;

static nn::bluetooth::BluetoothAddress bdAddrForSetGet;

class myBtClient : public bluetoothClient
{
    public:

    private:


    void EventFromConnectionStateCallback(const nn::bluetooth::InfoFromConnectionStateCallback* pInfo)
    {
        bluetoothClient::EventFromConnectionStateCallback(pInfo);

        if(pInfo->state==nn::bluetooth::BTHH_CONN_STATE_CONNECTED)
        {
            setTsi(pInfo->bluetoothAddress, 8);
        }
    }

    void EventFromExtensionCallbacks(const nn::bluetooth::InfoFromExtensionCallbacks* pInfo)
    {
        bluetoothClient::EventFromExtensionCallbacks(pInfo);

        if(pInfo->eventType==nn::bluetooth::EventFromTsiSetCallback)
        {
            bdAddrForSetGet = pInfo->bluetoothAddress;
            stateForSetGet = SETGET_READY_TO_SEND_SET;
        }
    }

    //-----------------------------------------------------------------------------
    // EventFromSetReportStatusCallback
    //
    void EventFromSetReportStatusCallback(const nn::bluetooth::InfoFromSetReportStatusCallback* pInfo)
    {
        bluetoothClient::EventFromSetReportStatusCallback(pInfo);
        stateForSetGet = SETGET_READY_TO_SEND_GET;
    }

    //-----------------------------------------------------------------------------
    // EventFromGetReportStatusCallback
    //
    void EventFromGetReportStatusCallback(const nn::bluetooth::InfoFromGetReportStatusCallback* pInfo)
    {
        bluetoothClient::EventFromGetReportStatusCallback(pInfo);
        stateForSetGet = SETGET_INIT;
    }

};


static myBtClient client;

//-----------------------------------------------------------------------------
extern "C" void nnMain()
{
    NN_LOG("myBtClient NOW RUNNING \n");

    client.startBluetooth();

    int loopTimeMs=0;

    stateForSetGet = SETGET_INIT;

    // try pairing every 30 seconds for 5 minutes, then try to stop Bluetooth
    while (1) //(loopTimeMs < 5*60*1000)
    {
        if((loopTimeMs % 30000)==0)
        {
            //Discovery
            NN_LOG("  [StartDiscovery]\n");
            nn::bluetooth::StartDiscovery();
        }
        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
        loopTimeMs += 100;

        if (stateForSetGet == SETGET_READY_TO_SEND_SET)
        {
            stateForSetGet = SETGET_WAIT_FOR_SET_STATUS;

            // TRY SENDING A "HidSetReport" MESSAGE (PART OF A MEMORY READ FOR OTA FW UPGRADE)
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
            nn::bluetooth::HidData hidData;
            memset(&hidData, 0, sizeof(hidData));
            hidData.length  = 8;
            hidData.data[0] = 0x71;       // APP_HH_OTAFWDL_HIDFWU_SETUP_READ
            uint32_t addr = 0xF8001FF4;   // APP_HH_OTAFWDL_SFLASH_BASE_ADDR + APP_HH_OTAFWDL_SFLASH_FAILSAFE_BASE_ADDR + APP_HH_OTAFWDL_SFLASH_MAGIC_NUMBER_OFFSET
            uint8_t *pAddr = (uint8_t*)&addr;
            hidData.data[1] = *pAddr++;
            hidData.data[2] = *pAddr++;
            hidData.data[3] = *pAddr++;
            hidData.data[4] = *pAddr++;
            uint16_t size = 256;          // APP_HH_OTAFWDL_HIDFWU_READSIZE
            uint8_t *pSize = (uint8_t*)&size;
            hidData.data[5] = *pSize++;
            hidData.data[6] = *pSize++;

            // calculate and save checksum
            int i;
            for (hidData.data[7]=0, i=0; i<7; i++)
                hidData.data[7] += hidData.data[i];
            hidData.data[7] = ~(hidData.data[7]-1);

            NN_LOG("  [HidSetReport] %s\n", bluetoothClient::toHexString(bdAddrForSetGet));
            NN_LOG("  [HidSetReport] %s\n", bluetoothClient::toHexString(8, hidData.data));
            nn::bluetooth::HidSetReport(&bdAddrForSetGet, nn::bluetooth::BTHH_FEATURE_REPORT, &hidData);
        }

        if (stateForSetGet == SETGET_READY_TO_SEND_GET)
        {
            stateForSetGet = SETGET_WAIT_FOR_GET_STATUS;

            // TRY SENDING A "HidGetReport" MESSAGE (PART OF A MEMORY READ FOR OTA FW UPGRADE)
            NN_LOG("  [HidGetReport] %s\n", bluetoothClient::toHexString(bdAddrForSetGet));
            nn::bluetooth::HidGetReport(
                    &bdAddrForSetGet, nn::bluetooth::BTHH_FEATURE_REPORT, 0x72); // APP_HH_OTAFWDL_HIDFWU_READ
        }
    }

    NN_LOG("  [Exiting...]\n");
    client.finishBluetooth();
}



