﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "AudioEchobackUtil.h"
#include <nn/audio/audio_AudioInApi.private.h>
#include <nn/audio/audio_DeviceApi-spec.nx.h>

void EnableAudioIn() NN_NOEXCEPT
{
    // NX スペックでは nn::audio::SetAudioInEnabled() を呼び出し、
    // オーディオ入力機能を有効化する必要があります。
    nn::audio::SetAudioInEnabled(true);
}

nn::Result AcquireAudioInDeviceNotification(nn::os::SystemEvent* pOutEvent) NN_NOEXCEPT
{
    return nn::audio::AcquireAudioDeviceNotificationForInput(pOutEvent);
}
