﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Simple.h"

#include "../FlagList.h"
#include "../GfxCode/DebugViewer.h"

namespace
{
    FlagList g_LocalFlagList(nullptr, 0);

    void UserWarningCallback(nn::atk::WarningCallbackArg arg)
    {
        nn::atk::PlayerHeapForWsdWarningCallbackInfo* pWarningInfo = static_cast<nn::atk::PlayerHeapForWsdWarningCallbackInfo*>(arg.pInfo);

        NN_LOG("WaringId : %d, ItemId : %d\n", arg.warningId, pWarningInfo->GetTargetId());
    }
}

void SimpleCheckModule::OnInitializeAtk() NN_NOEXCEPT
{
    m_CommonObject.Initialize();

    nn::atk::SoundSystem::SetWarningCallback(UserWarningCallback);
}

void SimpleCheckModule::OnFinalizeAtk() NN_NOEXCEPT
{
    m_CommonObject.Finalize();
}

void SimpleCheckModule::OnLoadData() NN_NOEXCEPT
{
    m_CommonObject.LoadData();
}

void SimpleCheckModule::OnPrintUsage() NN_NOEXCEPT
{
    m_CommonObject.PrintUsage();

    NN_LOG("[Down]         StartSound SEQ  (SEQ_MARIOKART)\n");
    NN_LOG("[Up]           StartSound SEQ  (SEQ_MARIOKART_PLAYERHEAP)\n");
    NN_LOG("[Left]         StartSound WSD  (SE_YOSHI_PLAYERHEAP)\n");
    NN_LOG("[Right]        StartSound WSD  (SE_YOSHI_PLAYERHEAP_FOR_USERGROUP)\n");
}

void SimpleCheckModule::OnUpdateInput() NN_NOEXCEPT
{
    m_CommonObject.UpdateInput();

    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Down >() )
    {
        m_CommonObject.PlayWithStartSound(SEQ_MARIOKART, "SEQ_MARIOKART");
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Up >() )
    {
        m_CommonObject.PlayWithStartSound(SEQ_MARIOKART_PLAYERHEAP, "SEQ_MARIOKART_PLAYERHEAP");
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Left >() )
    {
        //m_CommonObject.PlayWithStartSound(SE_YOSHI_PLAYERHEAP, "SE_YOSHI_PLAYERHEAP");
        m_CommonObject.PlayWithStartSound(WSD_YOSHI_DEBUG, "WSD_YOSHI_DEBUG");
        m_CommonObject.PlayWithStartSound(WSD_WIHAHO_DEBUG, "WSD_WIHAHO_DEBUG");
    }
    if ( nns::atk::IsTrigger< ::nn::hid::DebugPadButton::Right >() )
    {
        m_CommonObject.PlayWithStartSound(SE_YOSHI_PLAYERHEAP_FOR_USERGROUP, "SE_YOSHI_PLAYERHEAP_FOR_USERGROUP");
    }
}

void SimpleCheckModule::OnUpdateAtk() NN_NOEXCEPT
{
    m_CommonObject.Update();
}

#if defined( NN_ATK_ENABLE_GFX_VIEWING )
void SimpleCheckModule::OnUpdateDraw() NN_NOEXCEPT
{
    m_CommonObject.UpdateDraw(GetModuleName());
}
#endif

FlagList& SimpleCheckModule::GetLocalFlagList() NN_NOEXCEPT
{
    return g_LocalFlagList;
}
