﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/demo/pad/win/demo_WPadWin.h>
#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <windows.h>

namespace nw
{
namespace demo
{

//------------------------------------------------------------------------------
const u8 WPadWin::DEFAULT_V_KEY_CONFIG[PAD_IDX_MAX] =
{
    VK_LBUTTON, // IDX_A
    VK_RBUTTON, // IDX_B
    'C', // IDX_C
    0, // IDX_X
    0, // IDX_Y
    'Z', // IDX_Z
    '2', // IDX_2
    '1', // IDX_1
    'H', // IDX_HOME
    'M', // IDX_MINUS
    'P', // IDX_PLUS
    0, // IDX_START
    0, // IDX_SELECT
    0, // IDX_ZL
    0, // IDX_ZR
    0, // IDX_L
    0, // IDX_R
    VK_LBUTTON, // IDX_TOUCH
    VK_UP,    // IDX_UP
    VK_DOWN,  // IDX_DOWN
    VK_LEFT,  // IDX_LEFT
    VK_RIGHT, // IDX_RIGHT
    0, // IDX_LS_UP
    0, // IDX_LS_DOWN
    0, // IDX_LS_LEFT
    0, // IDX_LS_RIGHT
    0, // IDX_RS_UP
    0, // IDX_RS_DOWN
    0, // IDX_RS_LEFT
    0, // IDX_RS_RIGHT
};

//------------------------------------------------------------------------------
WPadWin::WPadWin()
: Pad(),
  m_PointerOffThreshold( 1.f ),
  m_KeyboardMouseDevice( NULL )
{
    SetVKeyConfigDefault();
}

//------------------------------------------------------------------------------
void
WPadWin::SetVKeyConfig(const u8* vkeyConfig)
{
    nw::ut::MemCpy( m_VKeyConfig, vkeyConfig, sizeof( m_VKeyConfig ) );
}

//------------------------------------------------------------------------------
void
WPadWin::SetVKeyConfig(PadIdx bit, u8 vkey)
{
    if (bit < PAD_IDX_MAX)
    {
        m_VKeyConfig[ bit ] = vkey;
    }
    else
    {
        NW_ERR( "range over[%d]\n", bit );
    }
}

//------------------------------------------------------------------------------
void
WPadWin::SetVKeyConfigDefault()
{
    nw::ut::MemCpy( m_VKeyConfig, DEFAULT_V_KEY_CONFIG, sizeof(m_VKeyConfig) );
}


//------------------------------------------------------------------------------
void
WPadWin::UpdateImpl()
{
    // パッドをクリア
    m_PadHold.SetAllZero();

    if ( m_KeyboardMouseDevice == NULL )
    {
        return;
    }

    // メインウインドウがアクティブな場合に、入力を受け付けます。
    bool isActive = ( m_KeyboardMouseDevice->GetActiveWindow() == KeyboardMouseDeviceWin::ACTIVE_WINDOW_MAIN ? true : false );

    // m_PadHold の設定
    if( isActive && m_KeyboardMouseDevice->IsKeyEnable() )
    {
        for ( int i = 0; i <= IDX_RIGHT; ++i )
        {
            if( m_KeyboardMouseDevice->IsVkeyHold( m_VKeyConfig[i] ) )
            {
                m_PadHold.SetBitOn( i );
            }
        }
    }

    m_LeftStick = nw::math::VEC2::Zero();
    m_RightStick = nw::math::VEC2::Zero();

    m_LeftAnalogTrigger = 0.f;
    m_RightAnalogTrigger = 0.f;

    // ポインティングデバイスの設定
    if ( isActive )
    {
        m_PointerPrev = m_Pointer;

        if ( IsPointerCenterOrigin() )
        {
            // 中央原点のとき
            const nw::math::VEC2& pos = m_KeyboardMouseDevice->GetCursorClientAreaPosCenterOrigin();
            SetPointerWithBound(
                - m_PointerOffThreshold <= pos.x && pos.x <= m_PointerOffThreshold &&
                - m_PointerOffThreshold <= pos.y && pos.y <= m_PointerOffThreshold,
                m_PadHold.IsMaskOn( MASK_TOUCH ),
                pos
            );
        }
        else
        {
            SetPointerWithBound(
                m_KeyboardMouseDevice->IsCursorOnClientArea(),
                m_PadHold.IsMaskOn( MASK_TOUCH ),
                m_KeyboardMouseDevice->GetCursorClientAreaPos()
            );
        }
    }
    else
    {
        // ウィンドウがアクティブでないときは値をクリア
        m_PointerFlag.SetAllZero();
        m_PadHold.SetMaskOff( MASK_TOUCH );
    }
}

} // namespace demo
} // namespace nw

