﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_PAD_UTIL_H_
#define NW_DEMO_PAD_UTIL_H_

#include <nw/types.h>
#include <nw/math/math_Vector2.h>

namespace nw
{
namespace demo
{
namespace detail
{

//! @brief        アナログスティックの値を、クランプをかけつつ設定します。
//!
//! @param[in]    stickValue    値の設定先へのポインタです。
//! @param[in]    rawValue      JOYINFOEX 構造体から取得したそのままの値です。
//! @param[in]    isReverse     反転を行うか否かです。true を与えると stickValue に書き込まれる数値の符号が反転します。
//! @param[in]    stickClampMin アナログスティックのクランプの下限値です。
//! @param[in]    stickClampMax アナログスティックのクランプの上限値です。
void SetStickValueWithClamp( float* stickValue, int rawValue, bool isReverse, int stickClampMin, int stickClampMax );

//! @brief        アナログスティックの値を正方形から円形に正規化します。
//!
//!               ただし、vec は予め -1 以上 1 以下にクランプされている必要があります。
//!
//! @param[in,out] vec      正規化するベクトルです。結果はこのポインタに上書きされて返されます。
void NormalizeAnalogStickAsCircle( nw::math::VEC2* vec );


//! @brief        PADRead で取得できるスティック値を正規化します。
//!
//! @param[out]    out      出力するスティック値です。
//! @param[in]     x        入力のスティック X 値です。
//! @param[in]     y        入力のスティック Y 値です。
void NormalizeStickValueCafe( nw::math::VEC2* out, s8 x, s8 y );


} // namespace detail
} // namespace demo
} // namespace nw

#endif // NW_DEMO_PAD_UTIL_H_
