﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_PAD_DEVICE_CAFE_H_
#define NW_DEMO_PAD_DEVICE_CAFE_H_

#include <cafe/pad.h>
#include <nw/types.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief        Cafe 用デモパッドデバイス情報管理クラスです。
//!
//! @details :category     入力デバイス
//---------------------------------------------------------------------------
class PadDeviceCafe
{
public:
    //---------------------------------------------------------------------------
    //! @brief        インスタンスを取得します。
    //!
    //! @return       シングルトンのインスタンスを返します。
    //---------------------------------------------------------------------------
    static PadDeviceCafe* GetInstance()
    {
        static PadDeviceCafe s_Instance;
        return &s_Instance;
    }


    //---------------------------------------------------------------------------
    //! @brief        初期化処理です。
    //---------------------------------------------------------------------------
    void Initialize();

    //---------------------------------------------------------------------------
    //! @brief        終了処理です。
    //---------------------------------------------------------------------------
    void Finalize() {}

    //---------------------------------------------------------------------------
    //! @brief        デバイスを更新します。
    //---------------------------------------------------------------------------
    void Update();

    //---------------------------------------------------------------------------
    //! @brief        PADライブラリで読み込んだ値の情報を取得します。
    //!
    //! @param[in]    channel   取得するチャンネルです。
    //!
    //! @return       パッドの状態を返します。
    //---------------------------------------------------------------------------
    const PADStatus& GetPadStatus(s32 channel) const { return m_PADStatuses[ channel ]; }


protected:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    PadDeviceCafe()
    {
        if (s_pInstance != NULL)
        {
            NW_FATAL_ERROR("nw::demo::PadDeviceCafe instance already exists.");
        }
        s_pInstance = this;
    }

    PADStatus m_PADStatuses[ PAD_MAX_CONTROLLERS ];

    static PadDeviceCafe* s_pInstance;
};

} // namespace demo
} // namespace nw

#endif // NW_DEMO_PAD_DEVICE_CAFE_H_
