﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_PAD_CAFE_H_
#define NW_DEMO_PAD_CAFE_H_

#include <nw/demo/pad/demo_Pad.h>
#include <nw/demo/pad/cafe/demo_PadDeviceCafe.h>

namespace nw
{
namespace demo
{

//---------------------------------------------------------------------------
//! @brief        Cafe デバッグ用パッドクラスです。
//!
//! @details :category     入力デバイス
//---------------------------------------------------------------------------
class PadCafe : public Pad
{
public:
    NW_UT_RUNTIME_TYPEINFO(Pad)

    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //!
    //! @param[in]    channel   接続先のチャンネルです。
    //---------------------------------------------------------------------------
    explicit PadCafe(s32 channel);

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~PadCafe() {}


    //---------------------------------------------------------------------------
    //! @brief        接続されているチャンネルを取得します。
    //!
    //! @return       チャンネルを返します。
    //---------------------------------------------------------------------------
    int GetChannel() const { return m_Channel; }

    //---------------------------------------------------------------------------
    //! @brief        パッドが接続状態にあるか否かを返します。
    //!
    //! @return       接続されている場合、 true を返します。
    //---------------------------------------------------------------------------
    virtual bool IsConnected() const { return m_IsConnected; }

    //---------------------------------------------------------------------------
    //! @brief        パッドデバイスを設定します。
    //!
    //! @param[in]    device    設定するデバイスへのポインタです。
    //---------------------------------------------------------------------------
    void SetPadDevice( PadDeviceCafe* device ){ m_PadDevice = device; }

    //---------------------------------------------------------------------------
    //! @brief        パッド状態を取得します。
    //!
    //! @param[out]   pad        出力するパッド状態へのポインタです。
    //---------------------------------------------------------------------------
    virtual void GetPadStatus( PADStatus* pad );


protected:
    virtual void UpdateImpl();
    void ClampStickValue( nw::math::VEC2* out, s8 x, s8 y );

    s32 m_Channel;      //!< 接続されているチャンネルです。
    bool m_IsConnected; //!< 接続されているかを表します。

    PadDeviceCafe* m_PadDevice; //!< 使用するパッドデバイスです。
};

} // namespace demo
} // namespace nw

#endif // NW_DEMO_PAD_CAFE_H_
