﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEMO_SYSTEM_H_
#define NW_DEMO_SYSTEM_H_

#include <nw/types.h>
#include <nw/demo/demo_Main.h>

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。

    #include <nw/demo/gl/demo_SystemWinGL.h>
    #include <nw/demo/gl/demo_SystemWinGLDRC.h>

#elif defined(NW_PLATFORM_CAFE)

    #include <nw/demo/cafe/demo_SystemCafe.h>
    #include <nw/demo/cafe/demo_SystemCafeDRC.h>

#endif

namespace nw
{
namespace demo
{

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
typedef SystemWinGL    DemoSystem;
typedef SystemWinGLDRC DemoSystemDRC;
#elif defined(NW_PLATFORM_CAFE)
typedef SystemCafe     DemoSystem;
typedef SystemCafeDRC  DemoSystemDRC;
#else
#error "Unknown platform"
#endif


} // namespace nw::demo
} // namespace nw

#endif // NW_DEMO_SYSTEM_H_
