﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_Types.h>

namespace nn { namespace gfx {

class ScissorStateInfo;

} } // namespace nn { namespace gfx {

namespace nns { namespace dbgui {

/**
* @brief ビューポートのY軸の方向
*/
enum ViewportYAxisDirection
{
    ViewportYAxisDirection_Up,
    ViewportYAxisDirection_Down
};

/**
* @brief Navigationのキーアサイン
*/
enum NavigationKeyBinding
{
    NavigationKeyBinding_Activate,
    NavigationKeyBinding_Cancel,
    NavigationKeyBinding_Input,
    NavigationKeyBinding_Menu,
    NavigationKeyBinding_Up,
    NavigationKeyBinding_Down,
    NavigationKeyBinding_Left,
    NavigationKeyBinding_Right,
    NavigationKeyBinding_FocusPrev,
    NavigationKeyBinding_FocusNext,
    NavigationKeyBinding_TweakSlow,
    NavigationKeyBinding_TweakFast,

    NavigationKeyBinding_Max,
};

/**
* @brief レンダリングの時、シザーを設定する前にシザーの座標を変換するコールバック
*
* @param[inout] pScissorStateInfo       シザーの矩形の情報
* @param[in] pUserData                  コールバックのユーザーデータ
*
* @details
* 低レベルグラフィクスAPIによってシザーの座標系が違うことがあるので、
* アプリが低レベルグラフィクスAPIとAPIの設定に合わせてシザーの座標を
* 変換できます。
*/
typedef void (*UpdateScissorCallback)(
    nn::gfx::ScissorStateInfo* pScissorStateInfo,
    void* pUserData);


/**
* @brief Navigation で ImGui からマウスの位置を設定する依頼の対応
*
* @param[in]            x               マウスの x の位置
* @param[in]            y               マウスの y の位置
* @param[in]            pUserData       コールバックのユーザデータ
*
* @details
* Navigation で ImGui からマウスの位置を設定する依頼の対応が来ることがあります。
* この時、アプリが設定したコールバックでアプリへ以来を転送します。
*/
typedef void (*MouseMoveFunction)(int x, int y, void* pUserData);

} } // namespace nns { namespace dbgui {
