﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace snddemo
{

    bool InitializeFs(nw::ut::IAllocator& allocator);
    void FinalizeFs(nw::ut::IAllocator& allocator);

    void InitializeSdkSound(u32 rendererSelect);
    void FinalizeSdkSound();
    void WaitForVBlank(nw::demo::DemoSystem* pDemo);

    void ConvertToPlatformDependentPath(const char* path, char* platformDependentPath);

#if defined(NW_PLATFORM_CAFE)
    void InitializeHostFileIo();
    void FinalizeHostFileIo();
    const char* GetHostFileIoMountPath();
    FSClient* GetFsClientPointer();
#endif

}
