﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "common/SampleSelector.h"

#if defined( NW_PLATFORM_CAFE )
#else
#include <cstdio>
#endif

namespace snddemo
{

    SampleSelector::SampleSelector()
    {
    }

    SampleSelector::~SampleSelector()
    {
    }

    int SampleSelector::Select(nw::demo::DemoSystem* pDemo, const char* sampleNames[], int sampleNum)
    {
        PrintMenu(sampleNames, sampleNum);
        NW_LOG("------------------------------------\n");

        int selectedNo = 0;
#if defined( NW_PLATFORM_CAFE )
        NW_LOG("↑↓：Select, A : Run\n");
        PrintSelectedItem(sampleNames, selectedNo);
        for (;;)
        {
            pDemo->UpdatePad();
            nw::demo::Pad* pad = pDemo->GetPad();

            if (pad->IsTrig(nw::demo::Pad::MASK_UP))
            {
                --selectedNo;
                if (selectedNo < 0)
                {
                    selectedNo = sampleNum - 1;
                }
                PrintSelectedItem(sampleNames, selectedNo);
            }
            else if (pad->IsTrig(nw::demo::Pad::MASK_DOWN))
            {
                ++selectedNo;
                if (selectedNo >= sampleNum)
                {
                    selectedNo = 0;
                }
                PrintSelectedItem(sampleNames, selectedNo);
            }
            else if (pad->IsTrig(nw::demo::Pad::MASK_A))
            {
                break;
            }

            OSSleepMilliseconds(16);
        }
#else
        NW_UNUSED_VARIABLE(pDemo);
        NW_LOG("Please input number. Sample starts if enter key is pressed.\n");
        for (;;)
        {
            NW_LOG("> ");
            int c = getchar();
            while (('\0' < c && c < '0') || '9' < c)
            {
                c = getchar();
            }
            while ('0' <= c && c <= '9')
            {
                selectedNo *= 10;
                selectedNo += c - '0';
                c = getchar();
            }

            if (selectedNo < sampleNum)
            {
                PrintSelectedItem(sampleNames, selectedNo);
                break;
            }
            else
            {
                selectedNo = 0;
            }
        }
#endif

        return selectedNo;
    }

    void SampleSelector::PrintItem(const char* sampleNames[], int index)
    {
        NW_LOG(" %d: %s\n", index, sampleNames[index]);
    }


    void SampleSelector::PrintMenu(const char* sampleNames[], int sampleNum)
    {
        NW_LOG("[Sample Menu]\n");
        for (int i = 0; i < sampleNum; ++i)
        {
            PrintItem(sampleNames, i);
        }
    }

    void SampleSelector::PrintSelectedItem(const char* sampleNames[], int selectedNo)
    {
        NW_LOG(">");
        PrintItem(sampleNames, selectedNo);
    }
}
