﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/snd.h>

namespace snddemo
{
    void InitializeSoundSystem(nw::ut::IAllocator& allocator);

    void InitializeFsSoundArchive(
        nw::snd::FsSoundArchive& soundArchive,
        const char* soundArchivePath,
        nw::ut::IAllocator& allocator);

    void InitializeSoundDataManager(
        nw::snd::SoundDataManager& soundDataManager,
        nw::snd::SoundArchive& soundArchive,
        nw::ut::IAllocator& allocator);

    void InitializeSoundArchivePlayer(
        nw::snd::SoundArchivePlayer& soundArchivePlayer,
        nw::snd::SoundDataManager& soundDataManager,
        nw::snd::SoundArchive& soundArchive,
        nw::ut::IAllocator& allocator);

    void InitializeSoundHeap(
        nw::snd::SoundHeap& soundHeap,
        int soundHeapSize,
        nw::ut::IAllocator& allocator);

    void FinalizeSoundSystem(nw::ut::IAllocator& allocator);

    void FinalizeFsSoundArchive(
        nw::snd::FsSoundArchive& soundArchive,
        nw::ut::IAllocator& allocator);

    void FinalizeSoundDataManager(
        nw::snd::SoundDataManager& soundDataManager,
        nw::ut::IAllocator& allocator);

    void FinalizeSoundArchivePlayer(
        nw::snd::SoundArchivePlayer& soundArchivePlayer,
        nw::ut::IAllocator& allocator);

    void FinalizeSoundHeap(
        nw::snd::SoundHeap& soundHeap,
        nw::ut::IAllocator& allocator);

    const char* GetCommmonSoundArchivePath();
}
