#----------------------------------------------------------------------------
# Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.
#
# These coded instructions, statements, and computer programs contain
# proprietary information of Nintendo of America Inc. and/or Nintendo
# Company Ltd., and are protected by Federal copyright law.  They may
# not be disclosed to third parties or copied or duplicated in any form,
# in whole or in part, without the prior written consent of Nintendo.
#----------------------------------------------------------------------------

LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)

LOCAL_MODULE        := g3d
ifeq ($(NW_BUILD), Debug)
LOCAL_CFLAGS        := -DNW_DEBUG
G3D_TARGET_LIB_DIR  := Debug
else
ifeq ($(NW_BUILD), Release)
LOCAL_CFLAGS        := -DNW_RELEASE
G3D_TARGET_LIB_DIR  := Release
else
LOCAL_CFLAGS        := -DNW_DEVELOP
G3D_TARGET_LIB_DIR  := Develop
endif
endif

LOCAL_MODULE        := g3d_simple
LOCAL_SRC_FILES     := $(subst ./jni/,,$(shell find -iname "*.c"))
LOCAL_SRC_FILES     += $(subst ./jni/,,$(shell find -iname "*.cpp"))
LOCAL_LDLIBS        := -llog -landroid -lEGL -lGLESv3 -lz -lg3d
LOCAL_LDFLAGS       := -L../../../../../Programs/Iris/Libraries/Android/$(G3D_TARGET_LIB_DIR)/local/$(TARGET_ARCH_ABI)
CAFE_INCLUDES       := $(subst \,/,$(CAFE_ROOT)/system/include)
LOCAL_C_INCLUDES    := $(CAFE_INCLUDES) ../../../../../Programs/Iris/Include

LOCAL_STATIC_LIBRARIES  := android_native_app_glue libg3d

include $(BUILD_SHARED_LIBRARY)

$(call import-module,android/native_app_glue)
