﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;

namespace NintendoWare.Spy
{
    public static class DirectoryUtility
    {
        /// <summary>
        /// 日時を表すディレクトリ（またはファイル）の名前を得ます。
        /// </summary>
        /// <param name="dateTime"></param>
        /// <returns></returns>
        public static string GetDateTimeName(DateTime dateTime)
        {
            return dateTime.ToString("yyyyMMdd_HHmmss");
        }

        /// <summary>
        /// 指定したパス内の、日時を表すパスを取得します。
        /// 実際に存在するパスとは衝突しない名前になります。
        /// </summary>
        /// <param name="basePath"></param>
        /// <param name="dateTime"></param>
        /// <returns></returns>
        public static string GetDateTimePath(string basePath, DateTime dateTime)
        {
            var path = Path.Combine(basePath, GetDateTimeName(dateTime));
            var result = path;
            int count = 1;

            while (Directory.Exists(result))
            {
                result = $"{path}_{count}";
                count++;
            }

            return result;
        }

        /// <summary>
        /// 指定したパス内の、現在の日時を表すパスを取得します。
        /// 実際に存在するパスとは衝突しない名前になります。
        /// </summary>
        /// <param name="basePath"></param>
        /// <returns></returns>
        public static string GetDateTimePath(string basePath)
        {
            return GetDateTimePath(basePath, DateTime.Now);
        }

        /// <summary>
        /// 指定したパス内の、日時を表すディレクトリの一覧を得ます。
        /// </summary>
        /// <param name="basePath"></param>
        /// <returns></returns>
        public static IEnumerable<string> EnumerateDateTimePath(string basePath)
        {
            return Directory.EnumerateDirectories(basePath)
                .Where(d => Regex.IsMatch(Path.GetFileName(d), @"^\d{7,}_\d{6}(_\d{1,})?$"));
        }
    }
}
