﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using NintendoWare.Spy.Collections;
using System.Collections.Generic;

namespace NintendoWare.Spy
{
    public class SpyDataPool : ISpyMandatoryModelAccessor
    {
        internal const string DataVersionDataName = "DataVersion";
        internal const uint DataVersionDataID = 0;

        private readonly DataVersionDictionary _dataVersions = new DataVersionDictionary();
        private readonly ObservableDictionary<string, SpyModel> _models = new ObservableDictionary<string, SpyModel>();
        private readonly IDictionary<string, SpyModel> _readonlyModels;

        //-----------------------------------------------------------------

        internal SpyDataPool()
        {
            _readonlyModels = new ReadOnlyObservableDictionary<string, SpyModel>(_models);
        }

        //-----------------------------------------------------------------

        public DataVersionDictionary DataVersions
        {
            get { return _dataVersions; }
        }

        public FrameSyncSpyModel FrameSyncModel { get; private set; }

        public IDictionary<string, SpyModel> Models
        {
            get { return _readonlyModels; }
        }

        public bool IsLittleEndian { get; set; }

        //-----------------------------------------------------------------

        internal void AddModel(string dataName, SpyModel model)
        {
            Assertion.Argument.StringIsNotNullOrEmpty(dataName);
            Assertion.Argument.NotNull(model);
            _models.Add(dataName, model);

            if (dataName == Plugins.FrameSyncSpyModelPlugin.SpyDataName)
            {
                this.FrameSyncModel = (FrameSyncSpyModel)model;
            }
        }

        internal void Initialize(ISpyDataReader reader)
        {
        }

        internal void Uninitialize()
        {
            _dataVersions.ClearData();
            foreach (var model in _models)
            {
                model.Value.Dispose();
            }
            _models.Clear();
            this.FrameSyncModel = null;
        }
    }
}
