﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;

namespace NintendoWare.Spy
{
    /// <summary>
    /// データバージョンの辞書です。
    /// </summary>
    public sealed class DataVersionDictionary
    {
        private readonly Dictionary<string, Version> _dataVersions = new Dictionary<string, Version>();

        internal DataVersionDictionary()
        {
        }

        //-----------------------------------------------------------------

        public Version this[string dataName]
        {
            get { return _dataVersions[dataName]; }
        }

        public int Count
        {
            get { return _dataVersions.Count; }
        }

        //-----------------------------------------------------------------

        public bool ContainsKey(string dataName)
        {
            return _dataVersions.ContainsKey(dataName);
        }

        internal void Add(string dataName, Version dataVersion)
        {
            _dataVersions.Add(dataName, dataVersion);
        }

        internal void ClearData()
        {
            _dataVersions.Clear();
        }
    }
}
