﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.Contracts;
using System.Collections.Generic;

namespace NintendoWare.Spy
{
    internal sealed class SpyModelRegistory
    {
        private readonly HashSet<string> _modelNames = new HashSet<string>();

        //-----------------------------------------------------------------

        public IEnumerable<string> AllDataNames
        {
            get { return _modelNames; }
        }

        //-----------------------------------------------------------------

        public void Register(string dataName)
        {
            Assertion.Argument.StringIsNotNullOrEmpty(dataName);

            _modelNames.Add(dataName);
        }

        public bool ModelExists(string dataName)
        {
            return _modelNames.Contains(dataName);
        }
    }
}
