﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.Spy
{
    /// <summary>
    /// 定数値コンフィグです。
    /// </summary>
    public static class ConstConfig
    {
        /// <summary>
        /// %APPDATA%/Company/Product/ フォルダの Company の設定です。
        /// </summary>
        public const string AppDataCompanyName = "Nintendo";

        /// <summary>
        /// 設定ファイルの拡張子です。
        /// </summary>
        public const string SettingsFileExtention = ".settings";

        /// <summary>
        /// データリストファイルの拡張子です。
        /// </summary>
        public const string SpyDataListFileExtention = ".spylist";

        /// <summary>
        /// データファイルの拡張子です。
        /// </summary>
        public const string SpyDataFileExtention = ".spydat";

        /// <summary>
        /// 設定アイテムのキーを管理します。
        /// </summary>
        public static class SettingItemKeys
        {
            /// <summary>
            /// アプリケーション設定のキーです。
            /// </summary>
            public const string ApplicationSettingsKey = "ApplicationSettings";

            /// <summary>
            /// 接続設定のキーです。
            /// </summary>
            public const string ConnectionSettingsKey = "ConnectionSettings";

            /// <summary>
            /// CafeAudio 設定のキーです。
            /// </summary>
            public const string CafeAudioSettingsKey = "CafeAudioSettings";
        }
    }
}
